/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.auth;

import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.RegionAwareSigner;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.runtime.auth.SignerProviderContext;
import software.amazon.awssdk.util.AwsHostNameUtils;

public class S3SignerProvider
extends SignerProvider {
    private static Logger log = LoggerFactory.getLogger(S3SignerProvider.class);
    private Signer signer;

    public S3SignerProvider(Signer defaultSigner) {
        this.signer = defaultSigner;
    }

    public Signer getSigner(SignerProviderContext signerProviderContext) {
        URI uri = signerProviderContext.getUri();
        if (this.signer instanceof RegionAwareSigner) {
            RegionAwareSigner regionSigner = (RegionAwareSigner)this.signer;
            try {
                regionSigner.setRegionName(AwsHostNameUtils.parseRegionName((String)uri.getHost(), (String)"s3"));
            }
            catch (RuntimeException e) {
                log.warn("Failed to parse the endpoint " + uri + ", and skip re-assigning the signer region", (Throwable)e);
            }
        }
        return this.signer;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }
}

