/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static software.amazon.awssdk.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringInputStream;

import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.XmlWriter;

/**
 * PutBucketLifecycleConfigurationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketLifecycleConfigurationRequestMarshaller implements
        Marshaller<Request<PutBucketLifecycleConfigurationRequest>, PutBucketLifecycleConfigurationRequest> {

    public Request<PutBucketLifecycleConfigurationRequest> marshall(
            PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) {

        if (putBucketLifecycleConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutBucketLifecycleConfigurationRequest> request = new DefaultRequest<PutBucketLifecycleConfigurationRequest>(
                putBucketLifecycleConfigurationRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        String uriResourcePath = "/{Bucket}?lifecycle";

        uriResourcePath = software.amazon.awssdk.util.UriResourcePathUtils.addStaticQueryParamtersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket",
                putBucketLifecycleConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            BucketLifecycleConfiguration lifecycleConfiguration = putBucketLifecycleConfigurationRequest.lifecycleConfiguration();
            if (lifecycleConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("LifecycleConfiguration");

                java.util.List<LifecycleRule> bucketLifecycleConfigurationRulesList = lifecycleConfiguration.rules();
                if (bucketLifecycleConfigurationRulesList != null) {
                    for (LifecycleRule bucketLifecycleConfigurationRulesListValue : bucketLifecycleConfigurationRulesList) {
                        xmlWriter.startElement("Rule");

                        LifecycleExpiration expiration = bucketLifecycleConfigurationRulesListValue.expiration();
                        if (expiration != null) {
                            xmlWriter.startElement("Expiration");

                            if (expiration.date() != null) {
                                xmlWriter.startElement("Date").value(expiration.date()).endElement();
                            }

                            if (expiration.days() != null) {
                                xmlWriter.startElement("Days").value(expiration.days()).endElement();
                            }

                            if (expiration.expiredObjectDeleteMarker() != null) {
                                xmlWriter.startElement("ExpiredObjectDeleteMarker").value(expiration.expiredObjectDeleteMarker())
                                        .endElement();
                            }
                            xmlWriter.endElement();
                        }

                        if (bucketLifecycleConfigurationRulesListValue.id() != null) {
                            xmlWriter.startElement("ID").value(bucketLifecycleConfigurationRulesListValue.id()).endElement();
                        }

                        if (bucketLifecycleConfigurationRulesListValue.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(bucketLifecycleConfigurationRulesListValue.prefix())
                                    .endElement();
                        }

                        LifecycleRuleFilter filter = bucketLifecycleConfigurationRulesListValue.filter();
                        if (filter != null) {
                            xmlWriter.startElement("Filter");

                            if (filter.prefix() != null) {
                                xmlWriter.startElement("Prefix").value(filter.prefix()).endElement();
                            }

                            Tag tag = filter.tag();
                            if (tag != null) {
                                xmlWriter.startElement("Tag");

                                if (tag.key() != null) {
                                    xmlWriter.startElement("Key").value(tag.key()).endElement();
                                }

                                if (tag.value() != null) {
                                    xmlWriter.startElement("Value").value(tag.value()).endElement();
                                }
                                xmlWriter.endElement();
                            }

                            LifecycleRuleAndOperator and = filter.and();
                            if (and != null) {
                                xmlWriter.startElement("And");

                                if (and.prefix() != null) {
                                    xmlWriter.startElement("Prefix").value(and.prefix()).endElement();
                                }

                                java.util.List<Tag> lifecycleRuleAndOperatorTagsList = and.tags();
                                if (lifecycleRuleAndOperatorTagsList != null) {
                                    for (Tag lifecycleRuleAndOperatorTagsListValue : lifecycleRuleAndOperatorTagsList) {
                                        xmlWriter.startElement("Tag");

                                        if (lifecycleRuleAndOperatorTagsListValue.key() != null) {
                                            xmlWriter.startElement("Key").value(lifecycleRuleAndOperatorTagsListValue.key())
                                                    .endElement();
                                        }

                                        if (lifecycleRuleAndOperatorTagsListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(lifecycleRuleAndOperatorTagsListValue.value())
                                                    .endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }

                        if (bucketLifecycleConfigurationRulesListValue.status() != null) {
                            xmlWriter.startElement("Status").value(bucketLifecycleConfigurationRulesListValue.status())
                                    .endElement();
                        }

                        java.util.List<Transition> lifecycleRuleTransitionsList = bucketLifecycleConfigurationRulesListValue
                                .transitions();
                        if (lifecycleRuleTransitionsList != null) {
                            for (Transition lifecycleRuleTransitionsListValue : lifecycleRuleTransitionsList) {
                                xmlWriter.startElement("Transition");

                                if (lifecycleRuleTransitionsListValue.date() != null) {
                                    xmlWriter.startElement("Date").value(lifecycleRuleTransitionsListValue.date()).endElement();
                                }

                                if (lifecycleRuleTransitionsListValue.days() != null) {
                                    xmlWriter.startElement("Days").value(lifecycleRuleTransitionsListValue.days()).endElement();
                                }

                                if (lifecycleRuleTransitionsListValue.storageClass() != null) {
                                    xmlWriter.startElement("StorageClass")
                                            .value(lifecycleRuleTransitionsListValue.storageClass()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                        }

                        java.util.List<NoncurrentVersionTransition> lifecycleRuleNoncurrentVersionTransitionsList = bucketLifecycleConfigurationRulesListValue
                                .noncurrentVersionTransitions();
                        if (lifecycleRuleNoncurrentVersionTransitionsList != null) {
                            for (NoncurrentVersionTransition lifecycleRuleNoncurrentVersionTransitionsListValue : lifecycleRuleNoncurrentVersionTransitionsList) {
                                xmlWriter.startElement("NoncurrentVersionTransition");

                                if (lifecycleRuleNoncurrentVersionTransitionsListValue.noncurrentDays() != null) {
                                    xmlWriter.startElement("NoncurrentDays")
                                            .value(lifecycleRuleNoncurrentVersionTransitionsListValue.noncurrentDays())
                                            .endElement();
                                }

                                if (lifecycleRuleNoncurrentVersionTransitionsListValue.storageClass() != null) {
                                    xmlWriter.startElement("StorageClass")
                                            .value(lifecycleRuleNoncurrentVersionTransitionsListValue.storageClass())
                                            .endElement();
                                }
                                xmlWriter.endElement();
                            }
                        }

                        NoncurrentVersionExpiration noncurrentVersionExpiration = bucketLifecycleConfigurationRulesListValue
                                .noncurrentVersionExpiration();
                        if (noncurrentVersionExpiration != null) {
                            xmlWriter.startElement("NoncurrentVersionExpiration");

                            if (noncurrentVersionExpiration.noncurrentDays() != null) {
                                xmlWriter.startElement("NoncurrentDays").value(noncurrentVersionExpiration.noncurrentDays())
                                        .endElement();
                            }
                            xmlWriter.endElement();
                        }

                        AbortIncompleteMultipartUpload abortIncompleteMultipartUpload = bucketLifecycleConfigurationRulesListValue
                                .abortIncompleteMultipartUpload();
                        if (abortIncompleteMultipartUpload != null) {
                            xmlWriter.startElement("AbortIncompleteMultipartUpload");

                            if (abortIncompleteMultipartUpload.daysAfterInitiation() != null) {
                                xmlWriter.startElement("DaysAfterInitiation")
                                        .value(abortIncompleteMultipartUpload.daysAfterInitiation()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}