/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static software.amazon.awssdk.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;

import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.XmlWriter;

/**
 * PutBucketAnalyticsConfigurationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketAnalyticsConfigurationRequestMarshaller implements
        Marshaller<Request<PutBucketAnalyticsConfigurationRequest>, PutBucketAnalyticsConfigurationRequest> {

    public Request<PutBucketAnalyticsConfigurationRequest> marshall(
            PutBucketAnalyticsConfigurationRequest putBucketAnalyticsConfigurationRequest) {

        if (putBucketAnalyticsConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutBucketAnalyticsConfigurationRequest> request = new DefaultRequest<PutBucketAnalyticsConfigurationRequest>(
                putBucketAnalyticsConfigurationRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        String uriResourcePath = "/{Bucket}?analytics";

        uriResourcePath = software.amazon.awssdk.util.UriResourcePathUtils.addStaticQueryParamtersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket",
                putBucketAnalyticsConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);

        if (putBucketAnalyticsConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString(putBucketAnalyticsConfigurationRequest.id()));
        }

        try {
            StringWriter stringWriter = null;
            AnalyticsConfiguration analyticsConfiguration = putBucketAnalyticsConfigurationRequest.analyticsConfiguration();
            if (analyticsConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("AnalyticsConfiguration");

                if (analyticsConfiguration.id() != null) {
                    xmlWriter.startElement("Id").value(analyticsConfiguration.id()).endElement();
                }

                AnalyticsFilter filter = analyticsConfiguration.filter();
                if (filter != null) {
                    xmlWriter.startElement("Filter");

                    if (filter.prefix() != null) {
                        xmlWriter.startElement("Prefix").value(filter.prefix()).endElement();
                    }

                    Tag tag = filter.tag();
                    if (tag != null) {
                        xmlWriter.startElement("Tag");

                        if (tag.key() != null) {
                            xmlWriter.startElement("Key").value(tag.key()).endElement();
                        }

                        if (tag.value() != null) {
                            xmlWriter.startElement("Value").value(tag.value()).endElement();
                        }
                        xmlWriter.endElement();
                    }

                    AnalyticsAndOperator and = filter.and();
                    if (and != null) {
                        xmlWriter.startElement("And");

                        if (and.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(and.prefix()).endElement();
                        }

                        java.util.List<Tag> analyticsAndOperatorTagsList = and.tags();
                        if (analyticsAndOperatorTagsList != null) {
                            for (Tag analyticsAndOperatorTagsListValue : analyticsAndOperatorTagsList) {
                                xmlWriter.startElement("Tag");

                                if (analyticsAndOperatorTagsListValue.key() != null) {
                                    xmlWriter.startElement("Key").value(analyticsAndOperatorTagsListValue.key()).endElement();
                                }

                                if (analyticsAndOperatorTagsListValue.value() != null) {
                                    xmlWriter.startElement("Value").value(analyticsAndOperatorTagsListValue.value()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                StorageClassAnalysis storageClassAnalysis = analyticsConfiguration.storageClassAnalysis();
                if (storageClassAnalysis != null) {
                    xmlWriter.startElement("StorageClassAnalysis");

                    StorageClassAnalysisDataExport dataExport = storageClassAnalysis.dataExport();
                    if (dataExport != null) {
                        xmlWriter.startElement("DataExport");

                        if (dataExport.outputSchemaVersion() != null) {
                            xmlWriter.startElement("OutputSchemaVersion").value(dataExport.outputSchemaVersion()).endElement();
                        }

                        AnalyticsExportDestination destination = dataExport.destination();
                        if (destination != null) {
                            xmlWriter.startElement("Destination");

                            AnalyticsS3BucketDestination s3BucketDestination = destination.s3BucketDestination();
                            if (s3BucketDestination != null) {
                                xmlWriter.startElement("S3BucketDestination");

                                if (s3BucketDestination.format() != null) {
                                    xmlWriter.startElement("Format").value(s3BucketDestination.format()).endElement();
                                }

                                if (s3BucketDestination.bucketAccountId() != null) {
                                    xmlWriter.startElement("BucketAccountId").value(s3BucketDestination.bucketAccountId())
                                            .endElement();
                                }

                                if (s3BucketDestination.bucket() != null) {
                                    xmlWriter.startElement("Bucket").value(s3BucketDestination.bucket()).endElement();
                                }

                                if (s3BucketDestination.prefix() != null) {
                                    xmlWriter.startElement("Prefix").value(s3BucketDestination.prefix()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}