/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * CompleteMultipartUploadResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CompleteMultipartUploadResponseUnmarshaller implements
        Unmarshaller<CompleteMultipartUploadResponse, StaxUnmarshallerContext> {

    public CompleteMultipartUploadResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        CompleteMultipartUploadResponse.Builder completeMultipartUploadResponse = CompleteMultipartUploadResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-expiration");
            completeMultipartUploadResponse.expiration(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption");
            completeMultipartUploadResponse.serverSideEncryption(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-version-id");
            completeMultipartUploadResponse.versionId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-aws-kms-key-id");
            completeMultipartUploadResponse.ssekmsKeyId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-request-charged");
            completeMultipartUploadResponse.requestCharged(StringUnmarshaller.getInstance().unmarshall(context));

        }

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Location", targetDepth)) {
                    completeMultipartUploadResponse.location(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Bucket", targetDepth)) {
                    completeMultipartUploadResponse.bucket(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Key", targetDepth)) {
                    completeMultipartUploadResponse.key(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ETag", targetDepth)) {
                    completeMultipartUploadResponse.eTag(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return completeMultipartUploadResponse.build();
    }

    private static CompleteMultipartUploadResponseUnmarshaller INSTANCE;

    public static CompleteMultipartUploadResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new CompleteMultipartUploadResponseUnmarshaller();
        return INSTANCE;
    }
}
