/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * CloudFunctionConfiguration StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CloudFunctionConfigurationUnmarshaller implements Unmarshaller<CloudFunctionConfiguration, StaxUnmarshallerContext> {

    public CloudFunctionConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        CloudFunctionConfiguration.Builder cloudFunctionConfiguration = CloudFunctionConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> events = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                cloudFunctionConfiguration.events(events);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Id", targetDepth)) {
                    cloudFunctionConfiguration.id(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Event", targetDepth)) {
                    cloudFunctionConfiguration.event(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Event", targetDepth)) {
                    if (events == null) {
                        events = new ArrayList<>();
                    }
                    events.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CloudFunction", targetDepth)) {
                    cloudFunctionConfiguration.cloudFunction(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("InvocationRole", targetDepth)) {
                    cloudFunctionConfiguration.invocationRole(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    cloudFunctionConfiguration.events(events);
                    break;
                }
            }
        }
        return cloudFunctionConfiguration.build();
    }

    private static CloudFunctionConfigurationUnmarshaller INSTANCE;

    public static CloudFunctionConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new CloudFunctionConfigurationUnmarshaller();
        return INSTANCE;
    }
}
