/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TargetGrant implements ToCopyableBuilder<TargetGrant.Builder, TargetGrant> {
    private final Grantee grantee;

    private final String permission;

    private TargetGrant(BuilderImpl builder) {
        this.grantee = builder.grantee;
        this.permission = builder.permission;
    }

    /**
     * Returns the value of the Grantee property for this object.
     * 
     * @return The value of the Grantee property for this object.
     */
    public Grantee grantee() {
        return grantee;
    }

    /**
     * Logging permissions assigned to the Grantee for the bucket.
     * 
     * @return Logging permissions assigned to the Grantee for the bucket.
     * @see BucketLogsPermission
     */
    public String permission() {
        return permission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((grantee() == null) ? 0 : grantee().hashCode());
        hashCode = 31 * hashCode + ((permission() == null) ? 0 : permission().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGrant)) {
            return false;
        }
        TargetGrant other = (TargetGrant) obj;
        if (other.grantee() == null ^ this.grantee() == null) {
            return false;
        }
        if (other.grantee() != null && !other.grantee().equals(this.grantee())) {
            return false;
        }
        if (other.permission() == null ^ this.permission() == null) {
            return false;
        }
        if (other.permission() != null && !other.permission().equals(this.permission())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (grantee() != null) {
            sb.append("Grantee: ").append(grantee()).append(",");
        }
        if (permission() != null) {
            sb.append("Permission: ").append(permission()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TargetGrant> {
        /**
         * Sets the value of the Grantee property for this object.
         *
         * @param grantee
         *        The new value for the Grantee property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantee(Grantee grantee);

        /**
         * Logging permissions assigned to the Grantee for the bucket.
         * 
         * @param permission
         *        Logging permissions assigned to the Grantee for the bucket.
         * @see BucketLogsPermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketLogsPermission
         */
        Builder permission(String permission);

        /**
         * Logging permissions assigned to the Grantee for the bucket.
         * 
         * @param permission
         *        Logging permissions assigned to the Grantee for the bucket.
         * @see BucketLogsPermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketLogsPermission
         */
        Builder permission(BucketLogsPermission permission);
    }

    private static final class BuilderImpl implements Builder {
        private Grantee grantee;

        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGrant model) {
            setGrantee(model.grantee);
            setPermission(model.permission);
        }

        public final Grantee getGrantee() {
            return grantee;
        }

        @Override
        public final Builder grantee(Grantee grantee) {
            this.grantee = grantee;
            return this;
        }

        public final void setGrantee(Grantee grantee) {
            this.grantee = grantee;
        }

        public final String getPermission() {
            return permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(BucketLogsPermission permission) {
            this.permission(permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        public final void setPermission(BucketLogsPermission permission) {
            this.permission(permission.toString());
        }

        @Override
        public TargetGrant build() {
            return new TargetGrant(this);
        }
    }
}
