/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ReplicationRule implements ToCopyableBuilder<ReplicationRule.Builder, ReplicationRule> {
    private final String id;

    private final String prefix;

    private final String status;

    private final Destination destination;

    private ReplicationRule(BuilderImpl builder) {
        this.id = builder.id;
        this.prefix = builder.prefix;
        this.status = builder.status;
        this.destination = builder.destination;
    }

    /**
     * Unique identifier for the rule. The value cannot be longer than 255 characters.
     * 
     * @return Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    public String id() {
        return id;
    }

    /**
     * Object keyname prefix identifying one or more objects to which the rule applies. Maximum prefix length can be up
     * to 1,024 characters. Overlapping prefixes are not supported.
     * 
     * @return Object keyname prefix identifying one or more objects to which the rule applies. Maximum prefix length
     *         can be up to 1,024 characters. Overlapping prefixes are not supported.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * The rule is ignored if status is not Enabled.
     * 
     * @return The rule is ignored if status is not Enabled.
     * @see ReplicationRuleStatus
     */
    public String status() {
        return status;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public Destination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((destination() == null) ? 0 : destination().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRule)) {
            return false;
        }
        ReplicationRule other = (ReplicationRule) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        if (other.destination() != null && !other.destination().equals(this.destination())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("ID: ").append(id()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (destination() != null) {
            sb.append("Destination: ").append(destination()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReplicationRule> {
        /**
         * Unique identifier for the rule. The value cannot be longer than 255 characters.
         * 
         * @param id
         *        Unique identifier for the rule. The value cannot be longer than 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Object keyname prefix identifying one or more objects to which the rule applies. Maximum prefix length can be
         * up to 1,024 characters. Overlapping prefixes are not supported.
         * 
         * @param prefix
         *        Object keyname prefix identifying one or more objects to which the rule applies. Maximum prefix length
         *        can be up to 1,024 characters. Overlapping prefixes are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * The rule is ignored if status is not Enabled.
         * 
         * @param status
         *        The rule is ignored if status is not Enabled.
         * @see ReplicationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationRuleStatus
         */
        Builder status(String status);

        /**
         * The rule is ignored if status is not Enabled.
         * 
         * @param status
         *        The rule is ignored if status is not Enabled.
         * @see ReplicationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationRuleStatus
         */
        Builder status(ReplicationRuleStatus status);

        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String prefix;

        private String status;

        private Destination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRule model) {
            setID(model.id);
            setPrefix(model.prefix);
            setStatus(model.status);
            setDestination(model.destination);
        }

        public final String getID() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReplicationRuleStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ReplicationRuleStatus status) {
            this.status(status.toString());
        }

        public final Destination getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination destination) {
            this.destination = destination;
        }

        @Override
        public ReplicationRule build() {
            return new ReplicationRule(this);
        }
    }
}
