/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketLifecycleConfigurationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutBucketLifecycleConfigurationRequest.Builder, PutBucketLifecycleConfigurationRequest> {
    private final String bucket;

    private final BucketLifecycleConfiguration lifecycleConfiguration;

    private PutBucketLifecycleConfigurationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the LifecycleConfiguration property for this object.
     * 
     * @return The value of the LifecycleConfiguration property for this object.
     */
    public BucketLifecycleConfiguration lifecycleConfiguration() {
        return lifecycleConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((lifecycleConfiguration() == null) ? 0 : lifecycleConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketLifecycleConfigurationRequest)) {
            return false;
        }
        PutBucketLifecycleConfigurationRequest other = (PutBucketLifecycleConfigurationRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.lifecycleConfiguration() == null ^ this.lifecycleConfiguration() == null) {
            return false;
        }
        if (other.lifecycleConfiguration() != null && !other.lifecycleConfiguration().equals(this.lifecycleConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (lifecycleConfiguration() != null) {
            sb.append("LifecycleConfiguration: ").append(lifecycleConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutBucketLifecycleConfigurationRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the LifecycleConfiguration property for this object.
         *
         * @param lifecycleConfiguration
         *        The new value for the LifecycleConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfiguration(BucketLifecycleConfiguration lifecycleConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private BucketLifecycleConfiguration lifecycleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketLifecycleConfigurationRequest model) {
            setBucket(model.bucket);
            setLifecycleConfiguration(model.lifecycleConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final BucketLifecycleConfiguration getLifecycleConfiguration() {
            return lifecycleConfiguration;
        }

        @Override
        public final Builder lifecycleConfiguration(BucketLifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        public final void setLifecycleConfiguration(BucketLifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
        }

        @Override
        public PutBucketLifecycleConfigurationRequest build() {
            return new PutBucketLifecycleConfigurationRequest(this);
        }
    }
}
