/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketAccelerateConfigurationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutBucketAccelerateConfigurationRequest.Builder, PutBucketAccelerateConfigurationRequest> {
    private final String bucket;

    private final AccelerateConfiguration accelerateConfiguration;

    private PutBucketAccelerateConfigurationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.accelerateConfiguration = builder.accelerateConfiguration;
    }

    /**
     * Name of the bucket for which the accelerate configuration is set.
     * 
     * @return Name of the bucket for which the accelerate configuration is set.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Specifies the Accelerate Configuration you want to set for the bucket.
     * 
     * @return Specifies the Accelerate Configuration you want to set for the bucket.
     */
    public AccelerateConfiguration accelerateConfiguration() {
        return accelerateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((accelerateConfiguration() == null) ? 0 : accelerateConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketAccelerateConfigurationRequest)) {
            return false;
        }
        PutBucketAccelerateConfigurationRequest other = (PutBucketAccelerateConfigurationRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.accelerateConfiguration() == null ^ this.accelerateConfiguration() == null) {
            return false;
        }
        if (other.accelerateConfiguration() != null && !other.accelerateConfiguration().equals(this.accelerateConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (accelerateConfiguration() != null) {
            sb.append("AccelerateConfiguration: ").append(accelerateConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutBucketAccelerateConfigurationRequest> {
        /**
         * Name of the bucket for which the accelerate configuration is set.
         * 
         * @param bucket
         *        Name of the bucket for which the accelerate configuration is set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Specifies the Accelerate Configuration you want to set for the bucket.
         * 
         * @param accelerateConfiguration
         *        Specifies the Accelerate Configuration you want to set for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerateConfiguration(AccelerateConfiguration accelerateConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private AccelerateConfiguration accelerateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketAccelerateConfigurationRequest model) {
            setBucket(model.bucket);
            setAccelerateConfiguration(model.accelerateConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final AccelerateConfiguration getAccelerateConfiguration() {
            return accelerateConfiguration;
        }

        @Override
        public final Builder accelerateConfiguration(AccelerateConfiguration accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration;
            return this;
        }

        public final void setAccelerateConfiguration(AccelerateConfiguration accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration;
        }

        @Override
        public PutBucketAccelerateConfigurationRequest build() {
            return new PutBucketAccelerateConfigurationRequest(this);
        }
    }
}
