/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ObjectIdentifier implements ToCopyableBuilder<ObjectIdentifier.Builder, ObjectIdentifier> {
    private final String key;

    private final String versionId;

    private ObjectIdentifier(BuilderImpl builder) {
        this.key = builder.key;
        this.versionId = builder.versionId;
    }

    /**
     * Key name of the object to delete.
     * 
     * @return Key name of the object to delete.
     */
    public String key() {
        return key;
    }

    /**
     * VersionId for the specific version of the object to delete.
     * 
     * @return VersionId for the specific version of the object to delete.
     */
    public String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((versionId() == null) ? 0 : versionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectIdentifier)) {
            return false;
        }
        ObjectIdentifier other = (ObjectIdentifier) obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ObjectIdentifier> {
        /**
         * Key name of the object to delete.
         * 
         * @param key
         *        Key name of the object to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * VersionId for the specific version of the object to delete.
         * 
         * @param versionId
         *        VersionId for the specific version of the object to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    private static final class BuilderImpl implements Builder {
        private String key;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectIdentifier model) {
            setKey(model.key);
            setVersionId(model.versionId);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public ObjectIdentifier build() {
            return new ObjectIdentifier(this);
        }
    }
}
