/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class InventoryDestination implements ToCopyableBuilder<InventoryDestination.Builder, InventoryDestination> {
    private final InventoryS3BucketDestination s3BucketDestination;

    private InventoryDestination(BuilderImpl builder) {
        this.s3BucketDestination = builder.s3BucketDestination;
    }

    /**
     * Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory results are
     * published.
     * 
     * @return Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory
     *         results are published.
     */
    public InventoryS3BucketDestination s3BucketDestination() {
        return s3BucketDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((s3BucketDestination() == null) ? 0 : s3BucketDestination().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryDestination)) {
            return false;
        }
        InventoryDestination other = (InventoryDestination) obj;
        if (other.s3BucketDestination() == null ^ this.s3BucketDestination() == null) {
            return false;
        }
        if (other.s3BucketDestination() != null && !other.s3BucketDestination().equals(this.s3BucketDestination())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (s3BucketDestination() != null) {
            sb.append("S3BucketDestination: ").append(s3BucketDestination()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InventoryDestination> {
        /**
         * Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory results
         * are published.
         * 
         * @param s3BucketDestination
         *        Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory
         *        results are published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketDestination(InventoryS3BucketDestination s3BucketDestination);
    }

    private static final class BuilderImpl implements Builder {
        private InventoryS3BucketDestination s3BucketDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryDestination model) {
            setS3BucketDestination(model.s3BucketDestination);
        }

        public final InventoryS3BucketDestination getS3BucketDestination() {
            return s3BucketDestination;
        }

        @Override
        public final Builder s3BucketDestination(InventoryS3BucketDestination s3BucketDestination) {
            this.s3BucketDestination = s3BucketDestination;
            return this;
        }

        public final void setS3BucketDestination(InventoryS3BucketDestination s3BucketDestination) {
            this.s3BucketDestination = s3BucketDestination;
        }

        @Override
        public InventoryDestination build() {
            return new InventoryDestination(this);
        }
    }
}
