/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBucketMetricsConfigurationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBucketMetricsConfigurationResponse.Builder, GetBucketMetricsConfigurationResponse> {
    private final MetricsConfiguration metricsConfiguration;

    private GetBucketMetricsConfigurationResponse(BuilderImpl builder) {
        this.metricsConfiguration = builder.metricsConfiguration;
    }

    /**
     * Specifies the metrics configuration.
     * 
     * @return Specifies the metrics configuration.
     */
    public MetricsConfiguration metricsConfiguration() {
        return metricsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((metricsConfiguration() == null) ? 0 : metricsConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketMetricsConfigurationResponse)) {
            return false;
        }
        GetBucketMetricsConfigurationResponse other = (GetBucketMetricsConfigurationResponse) obj;
        if (other.metricsConfiguration() == null ^ this.metricsConfiguration() == null) {
            return false;
        }
        if (other.metricsConfiguration() != null && !other.metricsConfiguration().equals(this.metricsConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (metricsConfiguration() != null) {
            sb.append("MetricsConfiguration: ").append(metricsConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBucketMetricsConfigurationResponse> {
        /**
         * Specifies the metrics configuration.
         * 
         * @param metricsConfiguration
         *        Specifies the metrics configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsConfiguration(MetricsConfiguration metricsConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private MetricsConfiguration metricsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketMetricsConfigurationResponse model) {
            setMetricsConfiguration(model.metricsConfiguration);
        }

        public final MetricsConfiguration getMetricsConfiguration() {
            return metricsConfiguration;
        }

        @Override
        public final Builder metricsConfiguration(MetricsConfiguration metricsConfiguration) {
            this.metricsConfiguration = metricsConfiguration;
            return this;
        }

        public final void setMetricsConfiguration(MetricsConfiguration metricsConfiguration) {
            this.metricsConfiguration = metricsConfiguration;
        }

        @Override
        public GetBucketMetricsConfigurationResponse build() {
            return new GetBucketMetricsConfigurationResponse(this);
        }
    }
}
