/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBucketLocationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBucketLocationResponse.Builder, GetBucketLocationResponse> {
    private final String locationConstraint;

    private GetBucketLocationResponse(BuilderImpl builder) {
        this.locationConstraint = builder.locationConstraint;
    }

    /**
     * Returns the value of the LocationConstraint property for this object.
     * 
     * @return The value of the LocationConstraint property for this object.
     * @see BucketLocationConstraint
     */
    public String locationConstraint() {
        return locationConstraint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((locationConstraint() == null) ? 0 : locationConstraint().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketLocationResponse)) {
            return false;
        }
        GetBucketLocationResponse other = (GetBucketLocationResponse) obj;
        if (other.locationConstraint() == null ^ this.locationConstraint() == null) {
            return false;
        }
        if (other.locationConstraint() != null && !other.locationConstraint().equals(this.locationConstraint())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (locationConstraint() != null) {
            sb.append("LocationConstraint: ").append(locationConstraint()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBucketLocationResponse> {
        /**
         * Sets the value of the LocationConstraint property for this object.
         *
         * @param locationConstraint
         *        The new value for the LocationConstraint property for this object.
         * @see BucketLocationConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketLocationConstraint
         */
        Builder locationConstraint(String locationConstraint);

        /**
         * Sets the value of the LocationConstraint property for this object.
         *
         * @param locationConstraint
         *        The new value for the LocationConstraint property for this object.
         * @see BucketLocationConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketLocationConstraint
         */
        Builder locationConstraint(BucketLocationConstraint locationConstraint);
    }

    private static final class BuilderImpl implements Builder {
        private String locationConstraint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketLocationResponse model) {
            setLocationConstraint(model.locationConstraint);
        }

        public final String getLocationConstraint() {
            return locationConstraint;
        }

        @Override
        public final Builder locationConstraint(String locationConstraint) {
            this.locationConstraint = locationConstraint;
            return this;
        }

        @Override
        public final Builder locationConstraint(BucketLocationConstraint locationConstraint) {
            this.locationConstraint(locationConstraint.toString());
            return this;
        }

        public final void setLocationConstraint(String locationConstraint) {
            this.locationConstraint = locationConstraint;
        }

        public final void setLocationConstraint(BucketLocationConstraint locationConstraint) {
            this.locationConstraint(locationConstraint.toString());
        }

        @Override
        public GetBucketLocationResponse build() {
            return new GetBucketLocationResponse(this);
        }
    }
}
