/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBucketAnalyticsConfigurationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBucketAnalyticsConfigurationResponse.Builder, GetBucketAnalyticsConfigurationResponse> {
    private final AnalyticsConfiguration analyticsConfiguration;

    private GetBucketAnalyticsConfigurationResponse(BuilderImpl builder) {
        this.analyticsConfiguration = builder.analyticsConfiguration;
    }

    /**
     * The configuration and any analyses for the analytics filter.
     * 
     * @return The configuration and any analyses for the analytics filter.
     */
    public AnalyticsConfiguration analyticsConfiguration() {
        return analyticsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((analyticsConfiguration() == null) ? 0 : analyticsConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketAnalyticsConfigurationResponse)) {
            return false;
        }
        GetBucketAnalyticsConfigurationResponse other = (GetBucketAnalyticsConfigurationResponse) obj;
        if (other.analyticsConfiguration() == null ^ this.analyticsConfiguration() == null) {
            return false;
        }
        if (other.analyticsConfiguration() != null && !other.analyticsConfiguration().equals(this.analyticsConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (analyticsConfiguration() != null) {
            sb.append("AnalyticsConfiguration: ").append(analyticsConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBucketAnalyticsConfigurationResponse> {
        /**
         * The configuration and any analyses for the analytics filter.
         * 
         * @param analyticsConfiguration
         *        The configuration and any analyses for the analytics filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyticsConfiguration(AnalyticsConfiguration analyticsConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private AnalyticsConfiguration analyticsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketAnalyticsConfigurationResponse model) {
            setAnalyticsConfiguration(model.analyticsConfiguration);
        }

        public final AnalyticsConfiguration getAnalyticsConfiguration() {
            return analyticsConfiguration;
        }

        @Override
        public final Builder analyticsConfiguration(AnalyticsConfiguration analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        public final void setAnalyticsConfiguration(AnalyticsConfiguration analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
        }

        @Override
        public GetBucketAnalyticsConfigurationResponse build() {
            return new GetBucketAnalyticsConfigurationResponse(this);
        }
    }
}
