/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.s3.model.MetadataCopier;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMultipartUploadRequest
extends S3Request
implements ToCopyableBuilder<Builder, CreateMultipartUploadRequest> {
    private final String acl;
    private final String bucket;
    private final String cacheControl;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final String contentType;
    private final Instant expires;
    private final String grantFullControl;
    private final String grantRead;
    private final String grantReadACP;
    private final String grantWriteACP;
    private final String key;
    private final Map<String, String> metadata;
    private final String serverSideEncryption;
    private final String storageClass;
    private final String websiteRedirectLocation;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKey;
    private final String sseCustomerKeyMD5;
    private final String ssekmsKeyId;
    private final String requestPayer;

    private CreateMultipartUploadRequest(BuilderImpl builder) {
        super(builder);
        this.acl = builder.acl;
        this.bucket = builder.bucket;
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.contentType = builder.contentType;
        this.expires = builder.expires;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWriteACP = builder.grantWriteACP;
        this.key = builder.key;
        this.metadata = builder.metadata;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.storageClass = builder.storageClass;
        this.websiteRedirectLocation = builder.websiteRedirectLocation;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.ssekmsKeyId = builder.ssekmsKeyId;
        this.requestPayer = builder.requestPayer;
    }

    public ObjectCannedACL acl() {
        return ObjectCannedACL.fromValue(this.acl);
    }

    public String aclAsString() {
        return this.acl;
    }

    public String bucket() {
        return this.bucket;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String contentType() {
        return this.contentType;
    }

    public Instant expires() {
        return this.expires;
    }

    public String grantFullControl() {
        return this.grantFullControl;
    }

    public String grantRead() {
        return this.grantRead;
    }

    public String grantReadACP() {
        return this.grantReadACP;
    }

    public String grantWriteACP() {
        return this.grantWriteACP;
    }

    public String key() {
        return this.key;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public ServerSideEncryption serverSideEncryption() {
        return ServerSideEncryption.fromValue(this.serverSideEncryption);
    }

    public String serverSideEncryptionAsString() {
        return this.serverSideEncryption;
    }

    public StorageClass storageClass() {
        return StorageClass.fromValue(this.storageClass);
    }

    public String storageClassAsString() {
        return this.storageClass;
    }

    public String websiteRedirectLocation() {
        return this.websiteRedirectLocation;
    }

    public String sseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String sseCustomerKey() {
        return this.sseCustomerKey;
    }

    public String sseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public String ssekmsKeyId() {
        return this.ssekmsKeyId;
    }

    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(this.requestPayer);
    }

    public String requestPayerAsString() {
        return this.requestPayer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aclAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentDisposition());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentEncoding());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.expires());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantFullControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantRead());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantReadACP());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantWriteACP());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteRedirectLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerKeyMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssekmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestPayerAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultipartUploadRequest)) {
            return false;
        }
        CreateMultipartUploadRequest other = (CreateMultipartUploadRequest)((Object)obj);
        return Objects.equals(this.aclAsString(), other.aclAsString()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.cacheControl(), other.cacheControl()) && Objects.equals(this.contentDisposition(), other.contentDisposition()) && Objects.equals(this.contentEncoding(), other.contentEncoding()) && Objects.equals(this.contentLanguage(), other.contentLanguage()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.expires(), other.expires()) && Objects.equals(this.grantFullControl(), other.grantFullControl()) && Objects.equals(this.grantRead(), other.grantRead()) && Objects.equals(this.grantReadACP(), other.grantReadACP()) && Objects.equals(this.grantWriteACP(), other.grantWriteACP()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.serverSideEncryptionAsString(), other.serverSideEncryptionAsString()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString()) && Objects.equals(this.websiteRedirectLocation(), other.websiteRedirectLocation()) && Objects.equals(this.sseCustomerAlgorithm(), other.sseCustomerAlgorithm()) && Objects.equals(this.sseCustomerKey(), other.sseCustomerKey()) && Objects.equals(this.sseCustomerKeyMD5(), other.sseCustomerKeyMD5()) && Objects.equals(this.ssekmsKeyId(), other.ssekmsKeyId()) && Objects.equals(this.requestPayerAsString(), other.requestPayerAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateMultipartUploadRequest").add("ACL", (Object)this.aclAsString()).add("Bucket", (Object)this.bucket()).add("CacheControl", (Object)this.cacheControl()).add("ContentDisposition", (Object)this.contentDisposition()).add("ContentEncoding", (Object)this.contentEncoding()).add("ContentLanguage", (Object)this.contentLanguage()).add("ContentType", (Object)this.contentType()).add("Expires", (Object)this.expires()).add("GrantFullControl", (Object)this.grantFullControl()).add("GrantRead", (Object)this.grantRead()).add("GrantReadACP", (Object)this.grantReadACP()).add("GrantWriteACP", (Object)this.grantWriteACP()).add("Key", (Object)this.key()).add("Metadata", this.metadata()).add("ServerSideEncryption", (Object)this.serverSideEncryptionAsString()).add("StorageClass", (Object)this.storageClassAsString()).add("WebsiteRedirectLocation", (Object)this.websiteRedirectLocation()).add("SSECustomerAlgorithm", (Object)this.sseCustomerAlgorithm()).add("SSECustomerKey", (Object)this.sseCustomerKey()).add("SSECustomerKeyMD5", (Object)this.sseCustomerKeyMD5()).add("SSEKMSKeyId", (Object)this.ssekmsKeyId()).add("RequestPayer", (Object)this.requestPayerAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ACL": {
                return Optional.ofNullable(clazz.cast(this.aclAsString()));
            }
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "CacheControl": {
                return Optional.ofNullable(clazz.cast(this.cacheControl()));
            }
            case "ContentDisposition": {
                return Optional.ofNullable(clazz.cast(this.contentDisposition()));
            }
            case "ContentEncoding": {
                return Optional.ofNullable(clazz.cast(this.contentEncoding()));
            }
            case "ContentLanguage": {
                return Optional.ofNullable(clazz.cast(this.contentLanguage()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "Expires": {
                return Optional.ofNullable(clazz.cast(this.expires()));
            }
            case "GrantFullControl": {
                return Optional.ofNullable(clazz.cast(this.grantFullControl()));
            }
            case "GrantRead": {
                return Optional.ofNullable(clazz.cast(this.grantRead()));
            }
            case "GrantReadACP": {
                return Optional.ofNullable(clazz.cast(this.grantReadACP()));
            }
            case "GrantWriteACP": {
                return Optional.ofNullable(clazz.cast(this.grantWriteACP()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "ServerSideEncryption": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionAsString()));
            }
            case "StorageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
            case "WebsiteRedirectLocation": {
                return Optional.ofNullable(clazz.cast(this.websiteRedirectLocation()));
            }
            case "SSECustomerAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.sseCustomerAlgorithm()));
            }
            case "SSECustomerKey": {
                return Optional.ofNullable(clazz.cast(this.sseCustomerKey()));
            }
            case "SSECustomerKeyMD5": {
                return Optional.ofNullable(clazz.cast(this.sseCustomerKeyMD5()));
            }
            case "SSEKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.ssekmsKeyId()));
            }
            case "RequestPayer": {
                return Optional.ofNullable(clazz.cast(this.requestPayerAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String acl;
        private String bucket;
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private String contentType;
        private Instant expires;
        private String grantFullControl;
        private String grantRead;
        private String grantReadACP;
        private String grantWriteACP;
        private String key;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String serverSideEncryption;
        private String storageClass;
        private String websiteRedirectLocation;
        private String sseCustomerAlgorithm;
        private String sseCustomerKey;
        private String sseCustomerKeyMD5;
        private String ssekmsKeyId;
        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultipartUploadRequest model) {
            super(model);
            this.acl(model.acl);
            this.bucket(model.bucket);
            this.cacheControl(model.cacheControl);
            this.contentDisposition(model.contentDisposition);
            this.contentEncoding(model.contentEncoding);
            this.contentLanguage(model.contentLanguage);
            this.contentType(model.contentType);
            this.expires(model.expires);
            this.grantFullControl(model.grantFullControl);
            this.grantRead(model.grantRead);
            this.grantReadACP(model.grantReadACP);
            this.grantWriteACP(model.grantWriteACP);
            this.key(model.key);
            this.metadata(model.metadata);
            this.serverSideEncryption(model.serverSideEncryption);
            this.storageClass(model.storageClass);
            this.websiteRedirectLocation(model.websiteRedirectLocation);
            this.sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            this.sseCustomerKey(model.sseCustomerKey);
            this.sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            this.ssekmsKeyId(model.ssekmsKeyId);
            this.requestPayer(model.requestPayer);
        }

        public final String getACL() {
            return this.acl;
        }

        @Override
        public final Builder acl(String acl) {
            this.acl = acl;
            return this;
        }

        @Override
        public final Builder acl(ObjectCannedACL acl) {
            this.acl(acl.toString());
            return this;
        }

        public final void setACL(String acl) {
            this.acl = acl;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getCacheControl() {
            return this.cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        public final String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public final String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public final void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        public final String getContentLanguage() {
            return this.contentLanguage;
        }

        @Override
        public final Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public final void setContentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Instant getExpires() {
            return this.expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        public final String getGrantFullControl() {
            return this.grantFullControl;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public final void setGrantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
        }

        public final String getGrantRead() {
            return this.grantRead;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public final void setGrantRead(String grantRead) {
            this.grantRead = grantRead;
        }

        public final String getGrantReadACP() {
            return this.grantReadACP;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public final void setGrantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
        }

        public final String getGrantWriteACP() {
            return this.grantWriteACP;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public final void setGrantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        public final String getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getWebsiteRedirectLocation() {
            return this.websiteRedirectLocation;
        }

        @Override
        public final Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        public final void setWebsiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
        }

        public final String getSSECustomerAlgorithm() {
            return this.sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKey() {
            return this.sseCustomerKey;
        }

        @Override
        public final Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public final void setSSECustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
        }

        public final String getSSECustomerKeyMD5() {
            return this.sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getSSEKMSKeyId() {
            return this.ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSSEKMSKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMultipartUploadRequest build() {
            return new CreateMultipartUploadRequest(this);
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    CopyableBuilder<Builder, CreateMultipartUploadRequest> {
        public Builder acl(String var1);

        public Builder acl(ObjectCannedACL var1);

        public Builder bucket(String var1);

        public Builder cacheControl(String var1);

        public Builder contentDisposition(String var1);

        public Builder contentEncoding(String var1);

        public Builder contentLanguage(String var1);

        public Builder contentType(String var1);

        public Builder expires(Instant var1);

        public Builder grantFullControl(String var1);

        public Builder grantRead(String var1);

        public Builder grantReadACP(String var1);

        public Builder grantWriteACP(String var1);

        public Builder key(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder serverSideEncryption(String var1);

        public Builder serverSideEncryption(ServerSideEncryption var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);

        public Builder websiteRedirectLocation(String var1);

        public Builder sseCustomerAlgorithm(String var1);

        public Builder sseCustomerKey(String var1);

        public Builder sseCustomerKeyMD5(String var1);

        public Builder ssekmsKeyId(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

