/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.MultipartUpload;
import software.amazon.awssdk.services.s3.transform.InitiatorUnmarshaller;
import software.amazon.awssdk.services.s3.transform.OwnerUnmarshaller;

public class MultipartUploadUnmarshaller
implements Unmarshaller<MultipartUpload, StaxUnmarshallerContext> {
    private static final MultipartUploadUnmarshaller INSTANCE = new MultipartUploadUnmarshaller();

    public MultipartUpload unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        MultipartUpload.Builder multipartUpload = MultipartUpload.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("UploadId", targetDepth)) {
                    multipartUpload.uploadId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Key", targetDepth)) {
                    multipartUpload.key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Initiated", targetDepth)) {
                    multipartUpload.initiated(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageClass", targetDepth)) {
                    multipartUpload.storageClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Owner", targetDepth)) {
                    multipartUpload.owner(OwnerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Initiator", targetDepth)) continue;
                multipartUpload.initiator(InitiatorUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (MultipartUpload)multipartUpload.build();
    }

    public static MultipartUploadUnmarshaller getInstance() {
        return INSTANCE;
    }
}

