/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;

public class HeadBucketRequestMarshaller
implements Marshaller<Request<HeadBucketRequest>, HeadBucketRequest> {
    public Request<HeadBucketRequest> marshall(HeadBucketRequest headBucketRequest) {
        if (headBucketRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)headBucketRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.HEAD);
        String uriResourcePath = "/{Bucket}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", headBucketRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

