/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class CompleteMultipartUploadRequestMarshaller
implements Marshaller<Request<CompleteMultipartUploadRequest>, CompleteMultipartUploadRequest> {
    public Request<CompleteMultipartUploadRequest> marshall(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        if (completeMultipartUploadRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)completeMultipartUploadRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.POST);
        if (completeMultipartUploadRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)completeMultipartUploadRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", completeMultipartUploadRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", completeMultipartUploadRequest.key());
        request.setResourcePath(uriResourcePath);
        if (completeMultipartUploadRequest.uploadId() != null) {
            request.addParameter("uploadId", StringConversion.fromString((String)completeMultipartUploadRequest.uploadId()));
        }
        try {
            StringWriter stringWriter = null;
            CompletedMultipartUpload multipartUpload = completeMultipartUploadRequest.multipartUpload();
            if (multipartUpload != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("CompleteMultipartUpload");
                List<CompletedPart> completedMultipartUploadPartsList = multipartUpload.parts();
                if (!completedMultipartUploadPartsList.isEmpty() || !(completedMultipartUploadPartsList instanceof SdkAutoConstructList)) {
                    for (CompletedPart completedMultipartUploadPartsListValue : completedMultipartUploadPartsList) {
                        xmlWriter.startElement("Part");
                        if (completedMultipartUploadPartsListValue.eTag() != null) {
                            xmlWriter.startElement("ETag").value(completedMultipartUploadPartsListValue.eTag()).endElement();
                        }
                        if (completedMultipartUploadPartsListValue.partNumber() != null) {
                            xmlWriter.startElement("PartNumber").value((Object)completedMultipartUploadPartsListValue.partNumber()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

