/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.transform.CommonPrefixUnmarshaller;
import software.amazon.awssdk.services.s3.transform.S3ObjectUnmarshaller;

public class ListObjectsResponseUnmarshaller
implements Unmarshaller<ListObjectsResponse, StaxUnmarshallerContext> {
    private static final ListObjectsResponseUnmarshaller INSTANCE = new ListObjectsResponseUnmarshaller();

    public ListObjectsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListObjectsResponse.Builder listObjectsResponse;
        block15: {
            listObjectsResponse = ListObjectsResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<S3Object> contents = null;
            ArrayList<CommonPrefix> commonPrefixes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listObjectsResponse.contents(contents);
                    listObjectsResponse.commonPrefixes(commonPrefixes);
                    break block15;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("IsTruncated", targetDepth)) {
                        listObjectsResponse.isTruncated(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Marker", targetDepth)) {
                        listObjectsResponse.marker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NextMarker", targetDepth)) {
                        listObjectsResponse.nextMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Contents", targetDepth)) {
                        if (contents == null) {
                            contents = new ArrayList<S3Object>();
                        }
                        contents.add(S3ObjectUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Name", targetDepth)) {
                        listObjectsResponse.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Prefix", targetDepth)) {
                        listObjectsResponse.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Delimiter", targetDepth)) {
                        listObjectsResponse.delimiter(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MaxKeys", targetDepth)) {
                        listObjectsResponse.maxKeys(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CommonPrefixes", targetDepth)) {
                        if (commonPrefixes == null) {
                            commonPrefixes = new ArrayList<CommonPrefix>();
                        }
                        commonPrefixes.add(CommonPrefixUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("EncodingType", targetDepth)) continue;
                    listObjectsResponse.encodingType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listObjectsResponse.contents(contents);
            listObjectsResponse.commonPrefixes(commonPrefixes);
        }
        return (ListObjectsResponse)((Object)listObjectsResponse.build());
    }

    public static ListObjectsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

