/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;

public class HeadObjectRequestMarshaller
implements Marshaller<Request<HeadObjectRequest>, HeadObjectRequest> {
    public Request<HeadObjectRequest> marshall(HeadObjectRequest headObjectRequest) {
        if (headObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)headObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.HEAD);
        if (headObjectRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)headObjectRequest.ifMatch()));
        }
        if (headObjectRequest.ifModifiedSince() != null) {
            request.addHeader("If-Modified-Since", StringUtils.fromInstant((Instant)headObjectRequest.ifModifiedSince()));
        }
        if (headObjectRequest.ifNoneMatch() != null) {
            request.addHeader("If-None-Match", StringUtils.fromString((String)headObjectRequest.ifNoneMatch()));
        }
        if (headObjectRequest.ifUnmodifiedSince() != null) {
            request.addHeader("If-Unmodified-Since", StringUtils.fromInstant((Instant)headObjectRequest.ifUnmodifiedSince()));
        }
        if (headObjectRequest.range() != null) {
            request.addHeader("Range", StringUtils.fromString((String)headObjectRequest.range()));
        }
        if (headObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringUtils.fromString((String)headObjectRequest.sseCustomerAlgorithm()));
        }
        if (headObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringUtils.fromString((String)headObjectRequest.sseCustomerKey()));
        }
        if (headObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringUtils.fromString((String)headObjectRequest.sseCustomerKeyMD5()));
        }
        if (headObjectRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)headObjectRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", headObjectRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", headObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (headObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString((String)headObjectRequest.versionId()));
        }
        if (headObjectRequest.partNumber() != null) {
            request.addParameter("partNumber", StringUtils.fromInteger((Integer)headObjectRequest.partNumber()));
        }
        return request;
    }
}

