/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.TransitionStorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Transition
implements ToCopyableBuilder<Builder, Transition> {
    private final Instant date;
    private final Integer days;
    private final String storageClass;

    private Transition(BuilderImpl builder) {
        this.date = builder.date;
        this.days = builder.days;
        this.storageClass = builder.storageClass;
    }

    public Instant date() {
        return this.date;
    }

    public Integer days() {
        return this.days;
    }

    public TransitionStorageClass storageClass() {
        return TransitionStorageClass.fromValue(this.storageClass);
    }

    public String storageClassAsString() {
        return this.storageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.days());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transition)) {
            return false;
        }
        Transition other = (Transition)obj;
        return Objects.equals(this.date(), other.date()) && Objects.equals(this.days(), other.days()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString());
    }

    public String toString() {
        return ToString.builder((String)"Transition").add("Date", (Object)this.date()).add("Days", (Object)this.days()).add("StorageClass", (Object)this.storageClassAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Date": {
                return Optional.of(clazz.cast(this.date()));
            }
            case "Days": {
                return Optional.of(clazz.cast(this.days()));
            }
            case "StorageClass": {
                return Optional.of(clazz.cast(this.storageClassAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant date;
        private Integer days;
        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(Transition model) {
            this.date(model.date);
            this.days(model.days);
            this.storageClass(model.storageClass);
        }

        public final Instant getDate() {
            return this.date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        public final Integer getDays() {
            return this.days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(TransitionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public Transition build() {
            return new Transition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Transition> {
        public Builder date(Instant var1);

        public Builder days(Integer var1);

        public Builder storageClass(String var1);

        public Builder storageClass(TransitionStorageClass var1);
    }
}

