/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.s3.model.Destination;
import software.amazon.awssdk.services.s3.model.ReplicationRuleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReplicationRule
implements ToCopyableBuilder<Builder, ReplicationRule> {
    private final String id;
    private final String prefix;
    private final String status;
    private final Destination destination;

    private ReplicationRule(BuilderImpl builder) {
        this.id = builder.id;
        this.prefix = builder.prefix;
        this.status = builder.status;
        this.destination = builder.destination;
    }

    public String id() {
        return this.id;
    }

    public String prefix() {
        return this.prefix;
    }

    public ReplicationRuleStatus status() {
        return ReplicationRuleStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Destination destination() {
        return this.destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRule)) {
            return false;
        }
        ReplicationRule other = (ReplicationRule)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.destination(), other.destination());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationRule").add("ID", (Object)this.id()).add("Prefix", (Object)this.prefix()).add("Status", (Object)this.statusAsString()).add("Destination", (Object)this.destination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ID": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "Destination": {
                return Optional.of(clazz.cast(this.destination()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String prefix;
        private String status;
        private Destination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRule model) {
            this.id(model.id);
            this.prefix(model.prefix);
            this.status(model.status);
            this.destination(model.destination);
        }

        public final String getID() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReplicationRuleStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public ReplicationRule build() {
            return new ReplicationRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicationRule> {
        public Builder id(String var1);

        public Builder prefix(String var1);

        public Builder status(String var1);

        public Builder status(ReplicationRuleStatus var1);

        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().apply(destination)).build());
        }
    }
}

