/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.Redirect;

public class RedirectUnmarshaller
implements Unmarshaller<Redirect, StaxUnmarshallerContext> {
    private static RedirectUnmarshaller INSTANCE;

    public Redirect unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Redirect.Builder redirect = Redirect.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HostName", targetDepth)) {
                    redirect.hostName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HttpRedirectCode", targetDepth)) {
                    redirect.httpRedirectCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Protocol", targetDepth)) {
                    redirect.protocol(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplaceKeyPrefixWith", targetDepth)) {
                    redirect.replaceKeyPrefixWith(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ReplaceKeyWith", targetDepth)) continue;
                redirect.replaceKeyWith(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Redirect)redirect.build();
    }

    public static RedirectUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RedirectUnmarshaller();
        }
        return INSTANCE;
    }
}

