/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.Date;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.util.StringUtils;

public class PutObjectRequestMarshaller
implements Marshaller<Request<PutObjectRequest>, PutObjectRequest> {
    public Request<PutObjectRequest> marshall(PutObjectRequest putObjectRequest) {
        if (putObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putObjectRequest.acl() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString((String)putObjectRequest.acl()));
        }
        if (putObjectRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringUtils.fromString((String)putObjectRequest.cacheControl()));
        }
        if (putObjectRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringUtils.fromString((String)putObjectRequest.contentDisposition()));
        }
        if (putObjectRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringUtils.fromString((String)putObjectRequest.contentEncoding()));
        }
        if (putObjectRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringUtils.fromString((String)putObjectRequest.contentLanguage()));
        }
        if (putObjectRequest.contentLength() != null) {
            request.addHeader("Content-Length", StringUtils.fromLong((Long)putObjectRequest.contentLength()));
        }
        if (putObjectRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString((String)putObjectRequest.contentMD5()));
        }
        if (putObjectRequest.contentType() != null) {
            request.addHeader("Content-Type", StringUtils.fromString((String)putObjectRequest.contentType()));
        }
        if (putObjectRequest.expires() != null) {
            request.addHeader("Expires", StringUtils.fromDate((Date)putObjectRequest.expires()));
        }
        if (putObjectRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString((String)putObjectRequest.grantFullControl()));
        }
        if (putObjectRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString((String)putObjectRequest.grantRead()));
        }
        if (putObjectRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString((String)putObjectRequest.grantReadACP()));
        }
        if (putObjectRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString((String)putObjectRequest.grantWriteACP()));
        }
        if (putObjectRequest.serverSideEncryption() != null) {
            request.addHeader("x-amz-server-side-encryption", StringUtils.fromString((String)putObjectRequest.serverSideEncryption()));
        }
        if (putObjectRequest.storageClass() != null) {
            request.addHeader("x-amz-storage-class", StringUtils.fromString((String)putObjectRequest.storageClass()));
        }
        if (putObjectRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", StringUtils.fromString((String)putObjectRequest.websiteRedirectLocation()));
        }
        if (putObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringUtils.fromString((String)putObjectRequest.sseCustomerAlgorithm()));
        }
        if (putObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringUtils.fromString((String)putObjectRequest.sseCustomerKey()));
        }
        if (putObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringUtils.fromString((String)putObjectRequest.sseCustomerKeyMD5()));
        }
        if (putObjectRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id", StringUtils.fromString((String)putObjectRequest.ssekmsKeyId()));
        }
        if (putObjectRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)putObjectRequest.requestPayer()));
        }
        if (putObjectRequest.tagging() != null) {
            request.addHeader("x-amz-tagging", StringUtils.fromString((String)putObjectRequest.tagging()));
        }
        if (putObjectRequest.metadata() != null) {
            putObjectRequest.metadata().entrySet().forEach(arg_0 -> PutObjectRequestMarshaller.lambda$marshall$0((Request)request, arg_0));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putObjectRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", putObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }

    private static /* synthetic */ void lambda$marshall$0(Request request, Map.Entry e) {
        if (((String)e.getKey()).startsWith("x-amz-meta-")) {
            request.addHeader((String)e.getKey(), (String)e.getValue());
        } else {
            request.addHeader("x-amz-meta-" + (String)e.getKey(), (String)e.getValue());
        }
    }
}

