/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.transform.DeletedObjectUnmarshaller;
import software.amazon.awssdk.services.s3.transform.S3ErrorUnmarshaller;

public class DeleteObjectsResponseUnmarshaller
implements Unmarshaller<DeleteObjectsResponse, StaxUnmarshallerContext> {
    private static DeleteObjectsResponseUnmarshaller INSTANCE;

    public DeleteObjectsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DeleteObjectsResponse.Builder deleteObjectsResponse = DeleteObjectsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-request-charged");
            deleteObjectsResponse.requestCharged(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Deleted", targetDepth)) {
                    deleteObjectsResponse.deleted(DeletedObjectUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Error", targetDepth)) continue;
                deleteObjectsResponse.errors(S3ErrorUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DeleteObjectsResponse)((Object)deleteObjectsResponse.build());
    }

    public static DeleteObjectsResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DeleteObjectsResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

