/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgressSnapshot;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResumeTransferProgress
implements TransferProgress {
    private CompletableFuture<TransferProgress> progressFuture;

    public ResumeTransferProgress(CompletableFuture<TransferProgress> progressFuture) {
        this.progressFuture = (CompletableFuture)Validate.paramNotNull(progressFuture, (String)"progressFuture");
    }

    @Override
    public TransferProgressSnapshot snapshot() {
        if (this.progressFuture.isDone() && !this.progressFuture.isCompletedExceptionally()) {
            return this.progressFuture.join().snapshot();
        }
        return DefaultTransferProgressSnapshot.builder().transferredBytes(0L).build();
    }
}

