/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.FileTransformerConfiguration;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.internal.async.FileAsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloadResumeContext;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloadUtils;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartS3AsyncClient;
import software.amazon.awssdk.services.s3.internal.resource.S3AccessPointResource;
import software.amazon.awssdk.services.s3.internal.resource.S3ArnConverter;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.multipart.PauseObservable;
import software.amazon.awssdk.services.s3.multipart.S3MultipartExecutionAttribute;
import software.amazon.awssdk.services.s3.multipart.S3ResumeToken;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.internal.DownloadDirectoryHelper;
import software.amazon.awssdk.transfer.s3.internal.ListObjectsHelper;
import software.amazon.awssdk.transfer.s3.internal.PauseResumeHelper;
import software.amazon.awssdk.transfer.s3.internal.TransferManagerConfiguration;
import software.amazon.awssdk.transfer.s3.internal.UploadDirectoryHelper;
import software.amazon.awssdk.transfer.s3.internal.model.DefaultCopy;
import software.amazon.awssdk.transfer.s3.internal.model.DefaultDirectoryDownload;
import software.amazon.awssdk.transfer.s3.internal.model.DefaultDirectoryUpload;
import software.amazon.awssdk.transfer.s3.internal.model.DefaultDownload;
import software.amazon.awssdk.transfer.s3.internal.model.DefaultFileDownload;
import software.amazon.awssdk.transfer.s3.internal.model.DefaultFileUpload;
import software.amazon.awssdk.transfer.s3.internal.model.DefaultUpload;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgress;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgressSnapshot;
import software.amazon.awssdk.transfer.s3.internal.progress.ResumeTransferProgress;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferProgressUpdater;
import software.amazon.awssdk.transfer.s3.internal.utils.ResumableRequestConverter;
import software.amazon.awssdk.transfer.s3.model.CompletedCopy;
import software.amazon.awssdk.transfer.s3.model.CompletedDownload;
import software.amazon.awssdk.transfer.s3.model.CompletedFileDownload;
import software.amazon.awssdk.transfer.s3.model.CompletedFileUpload;
import software.amazon.awssdk.transfer.s3.model.CompletedUpload;
import software.amazon.awssdk.transfer.s3.model.Copy;
import software.amazon.awssdk.transfer.s3.model.CopyRequest;
import software.amazon.awssdk.transfer.s3.model.DirectoryDownload;
import software.amazon.awssdk.transfer.s3.model.DirectoryUpload;
import software.amazon.awssdk.transfer.s3.model.Download;
import software.amazon.awssdk.transfer.s3.model.DownloadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.DownloadRequest;
import software.amazon.awssdk.transfer.s3.model.FileDownload;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.ResumableFileDownload;
import software.amazon.awssdk.transfer.s3.model.ResumableFileUpload;
import software.amazon.awssdk.transfer.s3.model.Upload;
import software.amazon.awssdk.transfer.s3.model.UploadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.model.UploadRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
class GenericS3TransferManager
implements S3TransferManager {
    private static final software.amazon.awssdk.utils.Logger log = software.amazon.awssdk.utils.Logger.loggerFor(S3TransferManager.class);
    private static final PauseResumeHelper PAUSE_RESUME_HELPER = new PauseResumeHelper();
    private final S3AsyncClient s3AsyncClient;
    private final UploadDirectoryHelper uploadDirectoryHelper;
    private final DownloadDirectoryHelper downloadDirectoryHelper;
    private final boolean isDefaultS3AsyncClient;
    private final TransferManagerConfiguration transferConfiguration;

    GenericS3TransferManager(TransferManagerConfiguration transferConfiguration, S3AsyncClient s3AsyncClient, boolean isDefaultS3AsyncClient) {
        this.s3AsyncClient = s3AsyncClient;
        this.transferConfiguration = transferConfiguration;
        this.uploadDirectoryHelper = new UploadDirectoryHelper(transferConfiguration, this::uploadFile);
        ListObjectsHelper listObjectsHelper = new ListObjectsHelper(arg_0 -> ((S3AsyncClient)s3AsyncClient).listObjectsV2(arg_0));
        this.downloadDirectoryHelper = new DownloadDirectoryHelper(transferConfiguration, listObjectsHelper, this::downloadFile);
        this.isDefaultS3AsyncClient = isDefaultS3AsyncClient;
    }

    @SdkTestInternalApi
    GenericS3TransferManager(S3AsyncClient s3AsyncClient, UploadDirectoryHelper uploadDirectoryHelper, TransferManagerConfiguration configuration, DownloadDirectoryHelper downloadDirectoryHelper) {
        this.s3AsyncClient = s3AsyncClient;
        this.isDefaultS3AsyncClient = false;
        this.transferConfiguration = configuration;
        this.uploadDirectoryHelper = uploadDirectoryHelper;
        this.downloadDirectoryHelper = downloadDirectoryHelper;
    }

    @Override
    public final Upload upload(UploadRequest uploadRequest) {
        Validate.paramNotNull((Object)uploadRequest, (String)"uploadRequest");
        AsyncRequestBody requestBody = uploadRequest.requestBody();
        CompletableFuture<CompletedUpload> returnFuture = new CompletableFuture<CompletedUpload>();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(uploadRequest, requestBody.contentLength().orElse(null));
        progressUpdater.transferInitiated();
        requestBody = progressUpdater.wrapRequestBody(requestBody);
        progressUpdater.registerCompletion(returnFuture);
        PutObjectRequest putObjectRequest = uploadRequest.putObjectRequest();
        if (this.isS3ClientMultipartEnabled()) {
            Consumer<AwsRequestOverrideConfiguration.Builder> attachProgressListener = b -> b.putExecutionAttribute(S3MultipartExecutionAttribute.JAVA_PROGRESS_LISTENER, progressUpdater.multipartClientProgressListener());
            putObjectRequest = this.attachSdkAttribute(uploadRequest.putObjectRequest(), attachProgressListener);
        }
        try {
            GenericS3TransferManager.assertNotUnsupportedArn(uploadRequest.putObjectRequest().bucket(), "upload");
            CompletableFuture future = this.s3AsyncClient.putObject(putObjectRequest, requestBody);
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)future);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)future, returnFuture, r -> CompletedUpload.builder().response((PutObjectResponse)r).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return new DefaultUpload(returnFuture, progressUpdater.progress());
    }

    @Override
    public FileUpload uploadFile(UploadFileRequest uploadFileRequest) {
        PauseObservable pauseObservable;
        Validate.paramNotNull((Object)uploadFileRequest, (String)"uploadFileRequest");
        AsyncRequestBody requestBody = (AsyncRequestBody)FileAsyncRequestBody.builder().path(uploadFileRequest.source()).build();
        CompletableFuture<CompletedFileUpload> returnFuture = new CompletableFuture<CompletedFileUpload>();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(uploadFileRequest, requestBody.contentLength().orElse(null));
        progressUpdater.transferInitiated();
        requestBody = progressUpdater.wrapRequestBody(requestBody);
        progressUpdater.registerCompletion(returnFuture);
        PutObjectRequest putObjectRequest = uploadFileRequest.putObjectRequest();
        if (this.isS3ClientMultipartEnabled()) {
            pauseObservable = new PauseObservable();
            Consumer<AwsRequestOverrideConfiguration.Builder> attachObservableAndListener = b -> ((AwsRequestOverrideConfiguration.Builder)b.putExecutionAttribute(S3MultipartExecutionAttribute.PAUSE_OBSERVABLE, (Object)pauseObservable)).putExecutionAttribute(S3MultipartExecutionAttribute.JAVA_PROGRESS_LISTENER, progressUpdater.multipartClientProgressListener());
            putObjectRequest = this.attachSdkAttribute(uploadFileRequest.putObjectRequest(), attachObservableAndListener);
        } else {
            pauseObservable = null;
        }
        try {
            GenericS3TransferManager.assertNotUnsupportedArn(putObjectRequest.bucket(), "upload");
            CompletableFuture putObjectFuture = this.s3AsyncClient.putObject(putObjectRequest, requestBody);
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)putObjectFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)putObjectFuture, returnFuture, r -> CompletedFileUpload.builder().response((PutObjectResponse)r).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return new DefaultFileUpload(returnFuture, progressUpdater.progress(), pauseObservable, uploadFileRequest);
    }

    @Override
    public final FileUpload resumeUploadFile(ResumableFileUpload resumableFileUpload) {
        boolean noResumeToken;
        Validate.paramNotNull((Object)resumableFileUpload, (String)"resumableFileUpload");
        boolean fileModified = PAUSE_RESUME_HELPER.fileModified(resumableFileUpload, this.s3AsyncClient);
        boolean bl = noResumeToken = !PAUSE_RESUME_HELPER.hasResumeToken(resumableFileUpload);
        if (fileModified || noResumeToken) {
            return this.uploadFile(resumableFileUpload.uploadFileRequest());
        }
        return this.doResumeUpload(resumableFileUpload);
    }

    private boolean isS3ClientMultipartEnabled() {
        return this.s3AsyncClient instanceof MultipartS3AsyncClient;
    }

    FileUpload doResumeUpload(ResumableFileUpload resumableFileUpload) {
        UploadFileRequest uploadFileRequest = resumableFileUpload.uploadFileRequest();
        PutObjectRequest putObjectRequest = uploadFileRequest.putObjectRequest();
        S3ResumeToken s3ResumeToken = GenericS3TransferManager.s3ResumeToken(resumableFileUpload);
        Consumer<AwsRequestOverrideConfiguration.Builder> attachResumeToken = b -> b.putExecutionAttribute(S3MultipartExecutionAttribute.RESUME_TOKEN, (Object)s3ResumeToken);
        PutObjectRequest modifiedPutObjectRequest = this.attachSdkAttribute(putObjectRequest, attachResumeToken);
        return this.uploadFile((UploadFileRequest)uploadFileRequest.toBuilder().putObjectRequest(modifiedPutObjectRequest).build());
    }

    private static S3ResumeToken s3ResumeToken(ResumableFileUpload resumableFileUpload) {
        S3ResumeToken.Builder builder = S3ResumeToken.builder();
        builder.uploadId((String)resumableFileUpload.multipartUploadId().orElse(null));
        if (resumableFileUpload.partSizeInBytes().isPresent()) {
            builder.partSize(Long.valueOf(resumableFileUpload.partSizeInBytes().getAsLong()));
        }
        if (resumableFileUpload.totalParts().isPresent()) {
            builder.totalNumParts(Long.valueOf(resumableFileUpload.totalParts().getAsLong()));
        }
        if (resumableFileUpload.transferredParts().isPresent()) {
            builder.numPartsCompleted(Long.valueOf(resumableFileUpload.transferredParts().getAsLong()));
        }
        return builder.build();
    }

    private PutObjectRequest attachSdkAttribute(PutObjectRequest putObjectRequest, Consumer<AwsRequestOverrideConfiguration.Builder> builderMutation) {
        AwsRequestOverrideConfiguration modifiedRequestOverrideConfig = putObjectRequest.overrideConfiguration().map(o -> ((AwsRequestOverrideConfiguration.Builder)o.toBuilder().applyMutation(builderMutation)).build()).orElseGet(() -> ((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(builderMutation)).build());
        return (PutObjectRequest)putObjectRequest.toBuilder().overrideConfiguration(modifiedRequestOverrideConfig).build();
    }

    private CopyObjectRequest attachSdkAttribute(CopyObjectRequest copyObjectRequest, Consumer<AwsRequestOverrideConfiguration.Builder> builderMutation) {
        AwsRequestOverrideConfiguration modifiedRequestOverrideConfig = copyObjectRequest.overrideConfiguration().map(o -> ((AwsRequestOverrideConfiguration.Builder)o.toBuilder().applyMutation(builderMutation)).build()).orElseGet(() -> ((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(builderMutation)).build());
        return (CopyObjectRequest)copyObjectRequest.toBuilder().overrideConfiguration(modifiedRequestOverrideConfig).build();
    }

    private GetObjectRequest attachSdkAttribute(GetObjectRequest request, Consumer<AwsRequestOverrideConfiguration.Builder> builderMutation) {
        AwsRequestOverrideConfiguration modifiedRequestOverrideConfig = request.overrideConfiguration().map(o -> ((AwsRequestOverrideConfiguration.Builder)o.toBuilder().applyMutation(builderMutation)).build()).orElseGet(() -> ((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(builderMutation)).build());
        return (GetObjectRequest)request.toBuilder().overrideConfiguration(modifiedRequestOverrideConfig).build();
    }

    @Override
    public final DirectoryUpload uploadDirectory(UploadDirectoryRequest uploadDirectoryRequest) {
        Validate.paramNotNull((Object)uploadDirectoryRequest, (String)"uploadDirectoryRequest");
        try {
            GenericS3TransferManager.assertNotUnsupportedArn(uploadDirectoryRequest.bucket(), "uploadDirectory");
            return this.uploadDirectoryHelper.uploadDirectory(uploadDirectoryRequest);
        }
        catch (Throwable throwable) {
            return new DefaultDirectoryUpload(CompletableFutureUtils.failedFuture((Throwable)throwable));
        }
    }

    @Override
    public final <ResultT> Download<ResultT> download(DownloadRequest<ResultT> downloadRequest) {
        Validate.paramNotNull(downloadRequest, (String)"downloadRequest");
        AsyncResponseTransformer<GetObjectResponse, ResultT> responseTransformer = downloadRequest.responseTransformer();
        CompletableFuture returnFuture = new CompletableFuture();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(downloadRequest, null);
        progressUpdater.transferInitiated();
        responseTransformer = this.isS3ClientMultipartEnabled() ? progressUpdater.wrapResponseTransformerForMultipartDownload(responseTransformer, downloadRequest.getObjectRequest()) : progressUpdater.wrapResponseTransformer(responseTransformer);
        progressUpdater.registerCompletion(returnFuture);
        try {
            GenericS3TransferManager.assertNotUnsupportedArn(downloadRequest.getObjectRequest().bucket(), "download");
            CompletableFuture future = this.s3AsyncClient.getObject(downloadRequest.getObjectRequest(), responseTransformer);
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)future);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)future, returnFuture, r -> (CompletedDownload)CompletedDownload.builder().result(r).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return new DefaultDownload(returnFuture, progressUpdater.progress());
    }

    @Override
    public final FileDownload downloadFile(DownloadFileRequest downloadRequest) {
        Validate.paramNotNull((Object)downloadRequest, (String)"downloadFileRequest");
        GetObjectRequest getObjectRequestWithAttributes = this.attachSdkAttribute(downloadRequest.getObjectRequest(), (AwsRequestOverrideConfiguration.Builder b) -> b.putExecutionAttribute(S3MultipartExecutionAttribute.MULTIPART_DOWNLOAD_RESUME_CONTEXT, (Object)new MultipartDownloadResumeContext()));
        DownloadFileRequest downloadFileRequestWithAttributes = (DownloadFileRequest)downloadRequest.copy(downloadFileRequest -> downloadFileRequest.getObjectRequest(getObjectRequestWithAttributes));
        AsyncResponseTransformer responseTransformer = AsyncResponseTransformer.toFile((Path)downloadFileRequestWithAttributes.destination(), (FileTransformerConfiguration)FileTransformerConfiguration.defaultCreateOrReplaceExisting());
        CompletableFuture<CompletedFileDownload> returnFuture = new CompletableFuture<CompletedFileDownload>();
        TransferProgressUpdater progressUpdater = this.doDownloadFile(downloadFileRequestWithAttributes, (AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>)responseTransformer, returnFuture);
        return new DefaultFileDownload(returnFuture, progressUpdater.progress(), () -> downloadFileRequestWithAttributes, null);
    }

    private TransferProgressUpdater doDownloadFile(DownloadFileRequest downloadRequest, AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> responseTransformer, CompletableFuture<CompletedFileDownload> returnFuture) {
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(downloadRequest, null);
        try {
            progressUpdater.transferInitiated();
            responseTransformer = this.isS3ClientMultipartEnabled() ? progressUpdater.wrapResponseTransformerForMultipartDownload(responseTransformer, downloadRequest.getObjectRequest()) : progressUpdater.wrapResponseTransformer(responseTransformer);
            progressUpdater.registerCompletion(returnFuture);
            GenericS3TransferManager.assertNotUnsupportedArn(downloadRequest.getObjectRequest().bucket(), "download");
            CompletableFuture future = this.s3AsyncClient.getObject(downloadRequest.getObjectRequest(), responseTransformer);
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)future);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)future, returnFuture, res -> CompletedFileDownload.builder().response((GetObjectResponse)res).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return progressUpdater;
    }

    @Override
    public final FileDownload resumeDownloadFile(ResumableFileDownload resumableFileDownload) {
        Validate.paramNotNull((Object)resumableFileDownload, (String)"resumableFileDownload");
        Optional optCtx = MultipartDownloadUtils.multipartDownloadResumeContext((GetObjectRequest)resumableFileDownload.downloadFileRequest().getObjectRequest());
        if (optCtx.map(MultipartDownloadResumeContext::isComplete).orElse(false).booleanValue()) {
            log.debug(() -> "The multipart download associated to the provided ResumableFileDownload is already completed, nothing to resume");
            return this.completedDownload(resumableFileDownload, (MultipartDownloadResumeContext)optCtx.get());
        }
        CompletableFuture<CompletedFileDownload> returnFuture = new CompletableFuture<CompletedFileDownload>();
        DownloadFileRequest originalDownloadRequest = resumableFileDownload.downloadFileRequest();
        GetObjectRequest getObjectRequest = originalDownloadRequest.getObjectRequest();
        CompletableFuture<TransferProgress> progressFuture = new CompletableFuture<TransferProgress>();
        CompletableFuture newDownloadFileRequestFuture = new CompletableFuture();
        CompletableFuture headFuture = this.s3AsyncClient.headObject(b -> b.bucket(getObjectRequest.bucket()).key(getObjectRequest.key()));
        CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)headFuture);
        ((CompletableFuture)headFuture.thenAccept(headObjectResponse -> {
            Pair<DownloadFileRequest, AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>> requestPair = ResumableRequestConverter.toDownloadFileRequestAndTransformer(resumableFileDownload, headObjectResponse, originalDownloadRequest);
            DownloadFileRequest newDownloadFileRequest = (DownloadFileRequest)requestPair.left();
            newDownloadFileRequestFuture.complete(newDownloadFileRequest);
            log.debug(() -> "Sending downloadFileRequest " + newDownloadFileRequest);
            TransferProgressUpdater progressUpdater = this.doDownloadFile(newDownloadFileRequest, (AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>)((AsyncResponseTransformer)requestPair.right()), returnFuture);
            progressFuture.complete(progressUpdater.progress());
        })).exceptionally(throwable -> {
            GenericS3TransferManager.handleException(returnFuture, progressFuture, newDownloadFileRequestFuture, throwable);
            return null;
        });
        return new DefaultFileDownload(returnFuture, new ResumeTransferProgress(progressFuture), () -> this.newOrOriginalRequestForPause(newDownloadFileRequestFuture, originalDownloadRequest), resumableFileDownload);
    }

    private FileDownload completedDownload(ResumableFileDownload resumableFileDownload, MultipartDownloadResumeContext ctx) {
        CompletedFileDownload completedFileDownload = CompletedFileDownload.builder().response(ctx.response()).build();
        DefaultTransferProgressSnapshot completedProgressSnapshot = DefaultTransferProgressSnapshot.builder().sdkResponse((SdkResponse)ctx.response()).totalBytes(ctx.bytesToLastCompletedParts()).transferredBytes(resumableFileDownload.bytesTransferred()).build();
        return new DefaultFileDownload(CompletableFuture.completedFuture(completedFileDownload), new DefaultTransferProgress(completedProgressSnapshot), resumableFileDownload::downloadFileRequest, resumableFileDownload);
    }

    private DownloadFileRequest newOrOriginalRequestForPause(CompletableFuture<DownloadFileRequest> newDownloadFuture, DownloadFileRequest originalDownloadRequest) {
        try {
            return newDownloadFuture.getNow(originalDownloadRequest);
        }
        catch (CompletionException e) {
            return originalDownloadRequest;
        }
    }

    private static void handleException(CompletableFuture<CompletedFileDownload> returnFuture, CompletableFuture<TransferProgress> progressFuture, CompletableFuture<DownloadFileRequest> newDownloadFileRequestFuture, Throwable throwable) {
        Throwable exceptionCause = throwable instanceof CompletionException ? throwable.getCause() : throwable;
        Throwable propagatedException = exceptionCause instanceof SdkException || exceptionCause instanceof Error ? exceptionCause : SdkClientException.create((String)"Failed to resume the request", (Throwable)exceptionCause);
        returnFuture.completeExceptionally(propagatedException);
        progressFuture.completeExceptionally(propagatedException);
        newDownloadFileRequestFuture.completeExceptionally(propagatedException);
    }

    @Override
    public final DirectoryDownload downloadDirectory(DownloadDirectoryRequest downloadDirectoryRequest) {
        Validate.paramNotNull((Object)downloadDirectoryRequest, (String)"downloadDirectoryRequest");
        try {
            GenericS3TransferManager.assertNotUnsupportedArn(downloadDirectoryRequest.bucket(), "downloadDirectoryRequest");
            return this.downloadDirectoryHelper.downloadDirectory(downloadDirectoryRequest);
        }
        catch (Throwable throwable) {
            return new DefaultDirectoryDownload(CompletableFutureUtils.failedFuture((Throwable)throwable));
        }
    }

    @Override
    public final Copy copy(CopyRequest copyRequest) {
        Validate.paramNotNull((Object)copyRequest, (String)"copyRequest");
        CompletableFuture<CompletedCopy> returnFuture = new CompletableFuture<CompletedCopy>();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(copyRequest, 10000L);
        if (this.isS3ClientMultipartEnabled()) {
            Consumer<AwsRequestOverrideConfiguration.Builder> attachProgressListener = b -> b.putExecutionAttribute(S3MultipartExecutionAttribute.JAVA_PROGRESS_LISTENER, progressUpdater.multipartClientProgressListener());
            CopyObjectRequest copyObjectRequest = this.attachSdkAttribute(copyRequest.copyObjectRequest(), attachProgressListener);
            copyRequest = copyRequest.toBuilder().copyObjectRequest(copyObjectRequest).build();
            progressUpdater.transferInitiated();
            progressUpdater.registerCompletion(returnFuture);
        }
        try {
            GenericS3TransferManager.assertNotUnsupportedArn(copyRequest.copyObjectRequest().sourceBucket(), "copy sourceBucket");
            GenericS3TransferManager.assertNotUnsupportedArn(copyRequest.copyObjectRequest().destinationBucket(), "copy destinationBucket");
            CompletableFuture future = this.s3AsyncClient.copyObject(copyRequest.copyObjectRequest());
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)future);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)future, returnFuture, r -> CompletedCopy.builder().response((CopyObjectResponse)r).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return new DefaultCopy(returnFuture, progressUpdater.progress());
    }

    public final void close() {
        if (this.isDefaultS3AsyncClient) {
            IoUtils.closeQuietly((AutoCloseable)this.s3AsyncClient, (Logger)log.logger());
        }
        IoUtils.closeQuietly((AutoCloseable)((Object)this.transferConfiguration), (Logger)log.logger());
    }

    protected static void assertNotUnsupportedArn(String bucket, String operation) {
        if (bucket == null) {
            return;
        }
        if (!bucket.startsWith("arn:")) {
            return;
        }
        if (GenericS3TransferManager.isObjectLambdaArn(bucket)) {
            String error = String.format("%s does not support S3 Object Lambda resources", operation);
            throw new IllegalArgumentException(error);
        }
        Arn arn = Arn.fromString((String)bucket);
        if (GenericS3TransferManager.isMrapArn(arn)) {
            String error = String.format("%s does not support S3 multi-region access point ARN", operation);
            throw new IllegalArgumentException(error);
        }
    }

    private static boolean isObjectLambdaArn(String arn) {
        return arn.contains(":s3-object-lambda");
    }

    private static boolean isMrapArn(Arn arn) {
        S3Resource s3Resource = S3ArnConverter.create().convertArn(arn);
        S3AccessPointResource s3EndpointResource = (S3AccessPointResource)Validate.isInstanceOf(S3AccessPointResource.class, (Object)s3Resource, (String)"An ARN was passed as a bucket parameter to an S3 operation, however it does not appear to be a valid S3 access point ARN.", (Object[])new Object[0]);
        return !s3EndpointResource.region().isPresent();
    }
}

