/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class ListObjectsHelper {
    private static final Logger logger = Logger.loggerFor(S3TransferManager.class);
    private final Function<ListObjectsV2Request, CompletableFuture<ListObjectsV2Response>> listObjectsFunction;
    private final S3ObjectsIteratorFunction objectsIteratorFunction = new S3ObjectsIteratorFunction();

    public ListObjectsHelper(Function<ListObjectsV2Request, CompletableFuture<ListObjectsV2Response>> listObjectsFunction) {
        this.listObjectsFunction = listObjectsFunction;
    }

    public SdkPublisher<S3Object> listS3ObjectsRecursively(ListObjectsV2Request firstRequest) {
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListObjectsV2ResponseFetcher(firstRequest)).iteratorFunction((Function)this.objectsIteratorFunction).isLastPage(false).build();
    }

    private final class ListObjectsV2ResponseFetcher
    implements AsyncPageFetcher<ListObjectsV2Response> {
        private final Deque<String> commonPrefixes = new ConcurrentLinkedDeque<String>();
        private volatile ListObjectsV2Request firstRequest;

        private ListObjectsV2ResponseFetcher(ListObjectsV2Request firstRequest) {
            this.firstRequest = firstRequest;
        }

        public boolean hasNextPage(ListObjectsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextContinuationToken()) || !this.commonPrefixes.isEmpty();
        }

        public CompletableFuture<ListObjectsV2Response> nextPage(ListObjectsV2Response previousPage) {
            CompletableFuture future;
            if (previousPage == null) {
                future = (CompletableFuture)ListObjectsHelper.this.listObjectsFunction.apply(this.firstRequest);
            } else if (PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextContinuationToken())) {
                future = (CompletableFuture)ListObjectsHelper.this.listObjectsFunction.apply((ListObjectsV2Request)this.firstRequest.toBuilder().continuationToken(previousPage.nextContinuationToken()).build());
            } else {
                String nextPrefix = this.commonPrefixes.pop();
                this.firstRequest = (ListObjectsV2Request)this.firstRequest.toBuilder().prefix(nextPrefix).build();
                future = (CompletableFuture)ListObjectsHelper.this.listObjectsFunction.apply(this.firstRequest);
            }
            return future.thenApply(t -> {
                List newCommonPrefixes = t.commonPrefixes();
                for (int i = newCommonPrefixes.size() - 1; i >= 0; --i) {
                    this.commonPrefixes.push(((CommonPrefix)newCommonPrefixes.get(i)).prefix());
                }
                return t;
            });
        }
    }

    private static final class S3ObjectsIteratorFunction
    implements Function<ListObjectsV2Response, Iterator<S3Object>> {
        private S3ObjectsIteratorFunction() {
        }

        @Override
        public Iterator<S3Object> apply(ListObjectsV2Response response) {
            if (response != null && !CollectionUtils.isNullOrEmpty((Collection)response.contents())) {
                return response.contents().stream().filter(r -> {
                    if (response.prefix() != null && response.prefix().equals(r.key())) {
                        logger.debug(() -> "Skipping download for object (" + r.key() + ") since it is a virtual directory");
                        return false;
                    }
                    return true;
                }).iterator();
            }
            return Collections.emptyIterator();
        }
    }
}

