/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.transfer.s3.internal.DefaultS3TransferManager;
import software.amazon.awssdk.transfer.s3.model.Copy;
import software.amazon.awssdk.transfer.s3.model.CopyRequest;
import software.amazon.awssdk.transfer.s3.model.DirectoryDownload;
import software.amazon.awssdk.transfer.s3.model.DirectoryUpload;
import software.amazon.awssdk.transfer.s3.model.Download;
import software.amazon.awssdk.transfer.s3.model.DownloadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.DownloadRequest;
import software.amazon.awssdk.transfer.s3.model.FileDownload;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.ResumableFileDownload;
import software.amazon.awssdk.transfer.s3.model.ResumableFileUpload;
import software.amazon.awssdk.transfer.s3.model.Upload;
import software.amazon.awssdk.transfer.s3.model.UploadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.model.UploadRequest;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public interface S3TransferManager
extends SdkAutoCloseable {
    default public FileDownload downloadFile(DownloadFileRequest downloadRequest) {
        throw new UnsupportedOperationException();
    }

    default public FileDownload downloadFile(Consumer<DownloadFileRequest.Builder> request) {
        return this.downloadFile((DownloadFileRequest)((DownloadFileRequest.Builder)DownloadFileRequest.builder().applyMutation(request)).build());
    }

    default public FileDownload resumeDownloadFile(ResumableFileDownload resumableFileDownload) {
        throw new UnsupportedOperationException();
    }

    default public FileDownload resumeDownloadFile(Consumer<ResumableFileDownload.Builder> resumableFileDownload) {
        return this.resumeDownloadFile((ResumableFileDownload)((ResumableFileDownload.Builder)ResumableFileDownload.builder().applyMutation(resumableFileDownload)).build());
    }

    default public <ResultT> Download<ResultT> download(DownloadRequest<ResultT> downloadRequest) {
        throw new UnsupportedOperationException();
    }

    default public FileUpload uploadFile(UploadFileRequest uploadFileRequest) {
        throw new UnsupportedOperationException();
    }

    default public FileUpload uploadFile(Consumer<UploadFileRequest.Builder> request) {
        return this.uploadFile((UploadFileRequest)((UploadFileRequest.Builder)UploadFileRequest.builder().applyMutation(request)).build());
    }

    default public FileUpload resumeUploadFile(ResumableFileUpload resumableFileUpload) {
        throw new UnsupportedOperationException();
    }

    default public FileUpload resumeUploadFile(Consumer<ResumableFileUpload.Builder> resumableFileUpload) {
        return this.resumeUploadFile((ResumableFileUpload)((ResumableFileUpload.Builder)ResumableFileUpload.builder().applyMutation(resumableFileUpload)).build());
    }

    default public Upload upload(UploadRequest uploadRequest) {
        throw new UnsupportedOperationException();
    }

    default public Upload upload(Consumer<UploadRequest.Builder> request) {
        return this.upload(((UploadRequest.Builder)UploadRequest.builder().applyMutation(request)).build());
    }

    default public DirectoryUpload uploadDirectory(UploadDirectoryRequest uploadDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    default public DirectoryUpload uploadDirectory(Consumer<UploadDirectoryRequest.Builder> requestBuilder) {
        Validate.paramNotNull(requestBuilder, (String)"requestBuilder");
        return this.uploadDirectory(((UploadDirectoryRequest.Builder)UploadDirectoryRequest.builder().applyMutation(requestBuilder)).build());
    }

    default public DirectoryDownload downloadDirectory(DownloadDirectoryRequest downloadDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    default public DirectoryDownload downloadDirectory(Consumer<DownloadDirectoryRequest.Builder> requestBuilder) {
        Validate.paramNotNull(requestBuilder, (String)"requestBuilder");
        return this.downloadDirectory((DownloadDirectoryRequest)((DownloadDirectoryRequest.Builder)DownloadDirectoryRequest.builder().applyMutation(requestBuilder)).build());
    }

    default public Copy copy(CopyRequest copyRequest) {
        throw new UnsupportedOperationException();
    }

    default public Copy copy(Consumer<CopyRequest.Builder> copyRequestBuilder) {
        return this.copy(((CopyRequest.Builder)CopyRequest.builder().applyMutation(copyRequestBuilder)).build());
    }

    public static S3TransferManager create() {
        return S3TransferManager.builder().build();
    }

    public static Builder builder() {
        return DefaultS3TransferManager.builder();
    }

    public static interface Builder {
        public Builder s3Client(S3AsyncClient var1);

        public Builder executor(Executor var1);

        public Builder uploadDirectoryFollowSymbolicLinks(Boolean var1);

        public Builder uploadDirectoryMaxDepth(Integer var1);

        public S3TransferManager build();
    }
}

