/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.internal.async.FileAsyncRequestBody;
import software.amazon.awssdk.crt.s3.ResumeToken;
import software.amazon.awssdk.http.SdkHttpExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpExecutionAttributes;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.crt.S3InternalSdkHttpExecutionAttribute;
import software.amazon.awssdk.services.s3.internal.crt.S3MetaRequestPauseObservable;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.internal.DelegatingS3TransferManager;
import software.amazon.awssdk.transfer.s3.internal.GenericS3TransferManager;
import software.amazon.awssdk.transfer.s3.internal.TransferManagerConfiguration;
import software.amazon.awssdk.transfer.s3.internal.model.CrtFileUpload;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferProgressUpdater;
import software.amazon.awssdk.transfer.s3.internal.utils.FileUtils;
import software.amazon.awssdk.transfer.s3.model.CompletedFileUpload;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.ResumableFileUpload;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
class CrtS3TransferManager
extends DelegatingS3TransferManager {
    private static final Logger log = Logger.loggerFor(S3TransferManager.class);
    private final S3AsyncClient s3AsyncClient;

    CrtS3TransferManager(TransferManagerConfiguration transferConfiguration, S3AsyncClient s3AsyncClient, boolean isDefaultS3AsyncClient) {
        super(new GenericS3TransferManager(transferConfiguration, s3AsyncClient, isDefaultS3AsyncClient));
        this.s3AsyncClient = s3AsyncClient;
    }

    @Override
    public FileUpload uploadFile(UploadFileRequest uploadFileRequest) {
        Validate.paramNotNull((Object)uploadFileRequest, (String)"uploadFileRequest");
        S3MetaRequestPauseObservable observable = new S3MetaRequestPauseObservable();
        AsyncRequestBody requestBody = (AsyncRequestBody)FileAsyncRequestBody.builder().path(uploadFileRequest.source()).chunkSizeInBytes(Integer.valueOf(0x1000000)).build();
        Consumer<SdkHttpExecutionAttributes.Builder> attachObservable = b -> b.put((SdkHttpExecutionAttribute)S3InternalSdkHttpExecutionAttribute.METAREQUEST_PAUSE_OBSERVABLE, (Object)observable);
        PutObjectRequest putObjectRequest = this.attachSdkAttribute(uploadFileRequest.putObjectRequest(), attachObservable);
        CompletableFuture<CompletedFileUpload> returnFuture = new CompletableFuture<CompletedFileUpload>();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(uploadFileRequest, requestBody);
        progressUpdater.transferInitiated();
        requestBody = progressUpdater.wrapRequestBody(requestBody);
        progressUpdater.registerCompletion(returnFuture);
        try {
            GenericS3TransferManager.assertNotUnsupportedArn(putObjectRequest.bucket(), "upload");
            CompletableFuture crtFuture = this.s3AsyncClient.putObject(putObjectRequest, requestBody);
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)crtFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)crtFuture, returnFuture, r -> CompletedFileUpload.builder().response((PutObjectResponse)r).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return new CrtFileUpload(returnFuture, progressUpdater.progress(), observable, uploadFileRequest);
    }

    private FileUpload uploadFromBeginning(ResumableFileUpload resumableFileUpload, boolean fileModified, boolean noResumeToken) {
        UploadFileRequest uploadFileRequest = resumableFileUpload.uploadFileRequest();
        PutObjectRequest putObjectRequest = uploadFileRequest.putObjectRequest();
        if (fileModified) {
            log.debug(() -> String.format("The file (%s) has been modified since the last pause. The SDK will upload the requested object in bucket (%s) with key (%s) from the beginning.", uploadFileRequest.source(), putObjectRequest.bucket(), putObjectRequest.key()));
            resumableFileUpload.multipartUploadId().ifPresent(id -> {
                log.debug(() -> "Aborting previous upload with multipartUploadId: " + id);
                this.s3AsyncClient.abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(putObjectRequest.bucket()).key(putObjectRequest.key()).uploadId(id).build()).exceptionally(t -> {
                    log.warn(() -> String.format("Failed to abort previous multipart upload (id: %s). You may need to call S3AsyncClient#abortMultiPartUpload to free all storage consumed by all parts. ", id), t);
                    return null;
                });
            });
        }
        if (noResumeToken) {
            log.debug(() -> String.format("No resume token is found. The SDK will upload the requested object in bucket (%s) with key (%s) from the beginning.", putObjectRequest.bucket(), putObjectRequest.key()));
        }
        return this.uploadFile(uploadFileRequest);
    }

    @Override
    public FileUpload resumeUploadFile(ResumableFileUpload resumableFileUpload) {
        boolean noResumeToken;
        Validate.paramNotNull((Object)resumableFileUpload, (String)"resumableFileUpload");
        boolean fileModified = !FileUtils.fileNotModified(resumableFileUpload.fileLength(), resumableFileUpload.fileLastModified(), resumableFileUpload.uploadFileRequest().source());
        boolean bl = noResumeToken = !this.hasResumeToken(resumableFileUpload);
        if (fileModified || noResumeToken) {
            return this.uploadFromBeginning(resumableFileUpload, fileModified, noResumeToken);
        }
        return this.doResumeUpload(resumableFileUpload);
    }

    private FileUpload doResumeUpload(ResumableFileUpload resumableFileUpload) {
        UploadFileRequest uploadFileRequest = resumableFileUpload.uploadFileRequest();
        PutObjectRequest putObjectRequest = uploadFileRequest.putObjectRequest();
        ResumeToken resumeToken = CrtS3TransferManager.crtResumeToken(resumableFileUpload);
        Consumer<SdkHttpExecutionAttributes.Builder> attachResumeToken = b -> b.put((SdkHttpExecutionAttribute)S3InternalSdkHttpExecutionAttribute.CRT_PAUSE_RESUME_TOKEN, (Object)resumeToken);
        PutObjectRequest modifiedPutObjectRequest = this.attachSdkAttribute(putObjectRequest, attachResumeToken);
        return this.uploadFile((UploadFileRequest)uploadFileRequest.toBuilder().putObjectRequest(modifiedPutObjectRequest).build());
    }

    private static ResumeToken crtResumeToken(ResumableFileUpload resumableFileUpload) {
        return new ResumeToken(new ResumeToken.PutResumeTokenBuilder().withNumPartsCompleted(resumableFileUpload.transferredParts().orElse(0L)).withTotalNumParts(resumableFileUpload.totalParts().orElse(0L)).withPartSize(resumableFileUpload.partSizeInBytes().getAsLong()).withUploadId((String)resumableFileUpload.multipartUploadId().orElse(null)));
    }

    private boolean hasResumeToken(ResumableFileUpload resumableFileUpload) {
        return resumableFileUpload.totalParts().isPresent() && resumableFileUpload.partSizeInBytes().isPresent();
    }

    private PutObjectRequest attachSdkAttribute(PutObjectRequest putObjectRequest, Consumer<SdkHttpExecutionAttributes.Builder> builderMutation) {
        SdkHttpExecutionAttributes modifiedAttributes = putObjectRequest.overrideConfiguration().map(o -> (SdkHttpExecutionAttributes)o.executionAttributes().getAttribute(SdkInternalExecutionAttribute.SDK_HTTP_EXECUTION_ATTRIBUTES)).map(b -> ((SdkHttpExecutionAttributes.Builder)b.toBuilder().applyMutation(builderMutation)).build()).orElseGet(() -> ((SdkHttpExecutionAttributes.Builder)SdkHttpExecutionAttributes.builder().applyMutation(builderMutation)).build());
        Consumer<AwsRequestOverrideConfiguration.Builder> attachSdkHttpAttributes = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.putExecutionAttribute(SdkInternalExecutionAttribute.SDK_HTTP_EXECUTION_ATTRIBUTES, (Object)modifiedAttributes);
        };
        AwsRequestOverrideConfiguration modifiedRequestOverrideConfig = putObjectRequest.overrideConfiguration().map(o -> ((AwsRequestOverrideConfiguration.Builder)o.toBuilder().applyMutation(attachSdkHttpAttributes)).build()).orElseGet(() -> ((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(attachSdkHttpAttributes)).build());
        return (PutObjectRequest)putObjectRequest.toBuilder().overrideConfiguration(modifiedRequestOverrideConfig).build();
    }
}

