/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.serialization;

import java.nio.file.Paths;
import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.protocols.jsoncore.JsonWriter;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.transfer.s3.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.ResumableFileDownload;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.internal.serialization.TransferManagerJsonMarshaller;
import software.amazon.awssdk.transfer.s3.internal.serialization.TransferManagerJsonUnmarshaller;
import software.amazon.awssdk.transfer.s3.internal.serialization.TransferManagerMarshallingUtils;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class ResumableFileDownloadSerializer {
    private static final Logger log = Logger.loggerFor(S3TransferManager.class);

    private ResumableFileDownloadSerializer() {
    }

    public static byte[] toJson(ResumableFileDownload download) {
        JsonWriter jsonGenerator = JsonWriter.create();
        jsonGenerator.writeStartObject();
        TransferManagerJsonMarshaller.LONG.marshall(download.bytesTransferred(), jsonGenerator, "bytesTransferred");
        TransferManagerJsonMarshaller.INSTANT.marshall(download.fileLastModified(), jsonGenerator, "fileLastModified");
        if (download.totalSizeInBytes().isPresent()) {
            TransferManagerJsonMarshaller.LONG.marshall(download.totalSizeInBytes().get(), jsonGenerator, "totalSizeInBytes");
        }
        if (download.s3ObjectLastModified().isPresent()) {
            TransferManagerJsonMarshaller.INSTANT.marshall(download.s3ObjectLastModified().get(), jsonGenerator, "s3ObjectLastModified");
        }
        ResumableFileDownloadSerializer.marshallDownloadFileRequest(download.downloadFileRequest(), jsonGenerator);
        jsonGenerator.writeEndObject();
        return jsonGenerator.getBytes();
    }

    private static void marshallDownloadFileRequest(DownloadFileRequest fileRequest, JsonWriter jsonGenerator) {
        jsonGenerator.writeFieldName("downloadFileRequest");
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName("destination");
        jsonGenerator.writeValue(fileRequest.destination().toString());
        ResumableFileDownloadSerializer.marshallGetObjectRequest(fileRequest.getObjectRequest(), jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    private static void marshallGetObjectRequest(GetObjectRequest getObjectRequest, JsonWriter jsonGenerator) {
        jsonGenerator.writeFieldName("getObjectRequest");
        jsonGenerator.writeStartObject();
        ResumableFileDownloadSerializer.validateNoRequestOverrideConfiguration(getObjectRequest);
        getObjectRequest.sdkFields().forEach(field -> ResumableFileDownloadSerializer.marshallPojoField(field, getObjectRequest, jsonGenerator));
        jsonGenerator.writeEndObject();
    }

    private static void validateNoRequestOverrideConfiguration(GetObjectRequest getObjectRequest) {
        if (getObjectRequest.overrideConfiguration().isPresent()) {
            log.debug(() -> "ResumableFileDownload GetObjectRequest contains an override configuration that will not be serialized");
        }
    }

    private static void marshallPojoField(SdkField<?> field, GetObjectRequest request, JsonWriter jsonGenerator) {
        Object val = field.getValueOrDefault((Object)request);
        TransferManagerJsonMarshaller<Object> marshaller = TransferManagerMarshallingUtils.getMarshaller(field.marshallingType(), val);
        marshaller.marshall(val, jsonGenerator, field.locationName());
    }

    public static ResumableFileDownload fromJson(byte[] bytes) {
        TransferManagerJsonUnmarshaller<Object> longUnmarshaller = TransferManagerMarshallingUtils.getUnmarshaller(MarshallingType.LONG);
        TransferManagerJsonUnmarshaller<Object> instantUnmarshaller = TransferManagerMarshallingUtils.getUnmarshaller(MarshallingType.INSTANT);
        JsonNodeParser jsonNodeParser = JsonNodeParser.builder().build();
        Map downloadNodes = jsonNodeParser.parse(bytes).asObject();
        ResumableFileDownload.Builder builder = ResumableFileDownload.builder();
        builder.bytesTransferred((Long)longUnmarshaller.unmarshall((JsonNode)downloadNodes.get("bytesTransferred")));
        builder.fileLastModified((Instant)instantUnmarshaller.unmarshall((JsonNode)downloadNodes.get("fileLastModified")));
        if (downloadNodes.get("totalSizeInBytes") != null) {
            builder.totalSizeInBytes((Long)longUnmarshaller.unmarshall((JsonNode)downloadNodes.get("totalSizeInBytes")));
        }
        if (downloadNodes.get("s3ObjectLastModified") != null) {
            builder.s3ObjectLastModified((Instant)instantUnmarshaller.unmarshall((JsonNode)downloadNodes.get("s3ObjectLastModified")));
        }
        builder.downloadFileRequest(ResumableFileDownloadSerializer.parseDownloadFileRequest((JsonNode)downloadNodes.get("downloadFileRequest")));
        return (ResumableFileDownload)builder.build();
    }

    private static DownloadFileRequest parseDownloadFileRequest(JsonNode fileRequest) {
        DownloadFileRequest.Builder fileRequestBuilder = DownloadFileRequest.builder();
        Map fileRequestNodes = fileRequest.asObject();
        fileRequestBuilder.destination(Paths.get(((JsonNode)fileRequestNodes.get("destination")).asString(), new String[0]));
        GetObjectRequest.Builder getObjectBuilder = GetObjectRequest.builder();
        Map getObjectRequestNodes = ((JsonNode)fileRequestNodes.get("getObjectRequest")).asObject();
        getObjectRequestNodes.forEach((key, value) -> ResumableFileDownloadSerializer.setGetObjectParameters(getObjectBuilder, key, value));
        fileRequestBuilder.getObjectRequest((GetObjectRequest)getObjectBuilder.build());
        return (DownloadFileRequest)fileRequestBuilder.build();
    }

    private static void setGetObjectParameters(GetObjectRequest.Builder getObjectBuilder, String key, JsonNode value) {
        SdkField<?> f = TransferManagerMarshallingUtils.getObjectSdkField(key);
        MarshallingType marshallingType = f.marshallingType();
        TransferManagerJsonUnmarshaller<Object> unmarshaller = TransferManagerMarshallingUtils.getUnmarshaller(marshallingType);
        f.set((Object)getObjectBuilder, unmarshaller.unmarshall(value));
    }
}

