/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class TransferRequestOverrideConfiguration
implements ToCopyableBuilder<Builder, TransferRequestOverrideConfiguration> {
    private final List<TransferListener> listeners;

    public TransferRequestOverrideConfiguration(DefaultBuilder builder) {
        this.listeners = builder.listeners != null ? Collections.unmodifiableList(builder.listeners) : Collections.emptyList();
    }

    public List<TransferListener> listeners() {
        return this.listeners;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRequestOverrideConfiguration that = (TransferRequestOverrideConfiguration)o;
        return Objects.equals(this.listeners, that.listeners);
    }

    public int hashCode() {
        return this.listeners != null ? this.listeners.hashCode() : 0;
    }

    public String toString() {
        return ToString.builder((String)"TransferRequestOverrideConfiguration").add("listeners", this.listeners).build();
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    private static final class DefaultBuilder
    implements Builder {
        private List<TransferListener> listeners;

        private DefaultBuilder(TransferRequestOverrideConfiguration configuration) {
            this.listeners = configuration.listeners;
        }

        private DefaultBuilder() {
        }

        @Override
        public Builder listeners(Collection<TransferListener> listeners) {
            this.listeners = new ArrayList<TransferListener>(listeners);
            return this;
        }

        @Override
        public Builder addListener(TransferListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<TransferListener>();
            }
            this.listeners.add(listener);
            return this;
        }

        public List<TransferListener> getListeners() {
            return this.listeners;
        }

        public void setListeners(Collection<TransferListener> listeners) {
            this.listeners(listeners);
        }

        @Override
        public TransferRequestOverrideConfiguration build() {
            return new TransferRequestOverrideConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TransferRequestOverrideConfiguration> {
        public Builder listeners(Collection<TransferListener> var1);

        public Builder addListener(TransferListener var1);

        public TransferRequestOverrideConfiguration build();
    }
}

