/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.transfer.s3.TransferObjectRequest;
import software.amazon.awssdk.transfer.s3.TransferRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class CopyRequest
implements TransferObjectRequest,
ToCopyableBuilder<Builder, CopyRequest> {
    private final CopyObjectRequest copyObjectRequest;
    private final TransferRequestOverrideConfiguration configuration;

    private CopyRequest(DefaultBuilder builder) {
        this.copyObjectRequest = (CopyObjectRequest)Validate.paramNotNull((Object)builder.copyObjectRequest, (String)"copyObjectRequest");
        this.configuration = builder.configuration;
    }

    public CopyObjectRequest copyObjectRequest() {
        return this.copyObjectRequest;
    }

    public Optional<TransferRequestOverrideConfiguration> overrideConfiguration() {
        return Optional.ofNullable(this.configuration);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyRequest that = (CopyRequest)o;
        if (!Objects.equals(this.copyObjectRequest, that.copyObjectRequest)) {
            return false;
        }
        return Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        int result = this.copyObjectRequest != null ? this.copyObjectRequest.hashCode() : 0;
        result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"CopyRequest").add("copyRequest", (Object)this.copyObjectRequest).add("configuration", (Object)this.configuration).build();
    }

    private static class DefaultBuilder
    implements Builder {
        private CopyObjectRequest copyObjectRequest;
        private TransferRequestOverrideConfiguration configuration;

        private DefaultBuilder() {
        }

        private DefaultBuilder(CopyRequest copyRequest) {
            this.copyObjectRequest = copyRequest.copyObjectRequest;
            this.configuration = copyRequest.configuration;
        }

        @Override
        public Builder copyObjectRequest(CopyObjectRequest copyRequest) {
            this.copyObjectRequest = copyRequest;
            return this;
        }

        public CopyObjectRequest getCopyObjectRequest() {
            return this.copyObjectRequest;
        }

        public void setCopyObjectRequest(CopyObjectRequest copyObjectRequest) {
            this.copyObjectRequest(copyObjectRequest);
        }

        @Override
        public Builder overrideConfiguration(TransferRequestOverrideConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public void setOverrideConfiguration(TransferRequestOverrideConfiguration configuration) {
            this.overrideConfiguration(configuration);
        }

        public TransferRequestOverrideConfiguration getOverrideConfiguration() {
            return this.configuration;
        }

        @Override
        public CopyRequest build() {
            return new CopyRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, CopyRequest> {
        public Builder copyObjectRequest(CopyObjectRequest var1);

        default public Builder copyObjectRequest(Consumer<CopyObjectRequest.Builder> copyRequestBuilder) {
            return this.copyObjectRequest((CopyObjectRequest)((CopyObjectRequest.Builder)CopyObjectRequest.builder().applyMutation(copyRequestBuilder)).build());
        }

        public Builder overrideConfiguration(TransferRequestOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<TransferRequestOverrideConfiguration.Builder> configurationBuilder) {
            Validate.paramNotNull(configurationBuilder, (String)"configurationBuilder");
            return this.overrideConfiguration(((TransferRequestOverrideConfiguration.Builder)TransferRequestOverrideConfiguration.builder().applyMutation(configurationBuilder)).build());
        }

        public CopyRequest build();
    }
}

