/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.progress;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.transfer.s3.CompletedTransfer;
import software.amazon.awssdk.transfer.s3.TransferRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;

@SdkPublicApi
@SdkPreviewApi
public interface TransferListener {
    default public void transferInitiated(Context.TransferInitiated context) {
    }

    default public void bytesTransferred(Context.BytesTransferred context) {
    }

    default public void transferComplete(Context.TransferComplete context) {
    }

    default public void transferFailed(Context.TransferFailed context) {
    }

    @SdkProtectedApi
    public static final class Context {
        private Context() {
        }

        @Immutable
        @ThreadSafe
        @SdkPublicApi
        @SdkPreviewApi
        public static interface TransferFailed
        extends TransferInitiated {
            public Throwable exception();
        }

        @Immutable
        @ThreadSafe
        @SdkPublicApi
        @SdkPreviewApi
        public static interface TransferComplete
        extends BytesTransferred {
            public CompletedTransfer completedTransfer();
        }

        @Immutable
        @ThreadSafe
        @SdkPublicApi
        @SdkPreviewApi
        public static interface BytesTransferred
        extends TransferInitiated {
        }

        @Immutable
        @ThreadSafe
        @SdkPublicApi
        @SdkPreviewApi
        public static interface TransferInitiated {
            public TransferRequest request();

            public TransferProgressSnapshot progressSnapshot();
        }
    }
}

