/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import com.amazonaws.s3.ResponseDataConsumer;
import com.amazonaws.s3.model.GetObjectOutput;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.transfer.s3.internal.CrtErrorHandler;
import software.amazon.awssdk.transfer.s3.internal.ResponseHeadersHandler;
import software.amazon.awssdk.transfer.s3.internal.S3CrtDataPublisher;
import software.amazon.awssdk.transfer.s3.internal.S3CrtPojoConversion;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class CrtResponseDataConsumerAdapter<ReturnT>
implements ResponseDataConsumer<GetObjectOutput> {
    private static final Logger log = Logger.loggerFor(CrtResponseDataConsumerAdapter.class);
    private final AsyncResponseTransformer<GetObjectResponse, ReturnT> transformer;
    private final CompletableFuture<ReturnT> future;
    private final S3CrtDataPublisher publisher;
    private final ResponseHeadersHandler headerHandler;
    private final CrtErrorHandler errorHandler;

    public CrtResponseDataConsumerAdapter(AsyncResponseTransformer<GetObjectResponse, ReturnT> transformer) {
        this(transformer, new S3CrtDataPublisher(), new ResponseHeadersHandler());
    }

    @SdkInternalApi
    CrtResponseDataConsumerAdapter(AsyncResponseTransformer<GetObjectResponse, ReturnT> transformer, S3CrtDataPublisher s3CrtDataPublisher, ResponseHeadersHandler headersHandler) {
        this.transformer = transformer;
        this.future = transformer.prepare();
        this.publisher = s3CrtDataPublisher;
        this.headerHandler = headersHandler;
        this.errorHandler = new CrtErrorHandler();
    }

    public CompletableFuture<ReturnT> transformerFuture() {
        return this.future;
    }

    public void onResponseHeaders(int statusCode, HttpHeader[] headers) {
        this.headerHandler.onResponseHeaders(statusCode, headers);
    }

    public void onResponse(GetObjectOutput output) {
        SdkHttpResponse sdkHttpResponse = this.headerHandler.sdkHttpResponseFuture().getNow((SdkHttpResponse)SdkHttpResponse.builder().build());
        GetObjectResponse response = S3CrtPojoConversion.fromCrtGetObjectOutput(output, sdkHttpResponse);
        this.transformer.onResponse((Object)response);
        this.transformer.onStream((SdkPublisher)this.publisher);
    }

    public void onResponseData(ByteBuffer byteBuffer) {
        log.trace(() -> "Received data of size " + byteBuffer.remaining());
        this.publisher.deliverData(byteBuffer);
    }

    public void onException(CrtRuntimeException e) {
        log.debug(() -> "An error occurred ", (Throwable)e);
        Exception transformException = this.errorHandler.transformException((Exception)e);
        this.transformer.exceptionOccurred((Throwable)transformException);
        this.publisher.notifyError(transformException);
    }

    public void onFinished() {
        log.debug(() -> "Finished streaming ");
        this.publisher.notifyStreamingFinished();
    }
}

