/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.crt.s3.CrtS3RuntimeException;
import software.amazon.awssdk.services.s3.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.InvalidObjectStateException;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.NoSuchUploadException;
import software.amazon.awssdk.services.s3.model.ObjectAlreadyInActiveTierErrorException;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public class CrtErrorHandler {
    private final Map<String, S3Exception.Builder> s3ExceptionBuilderMap = this.getS3ExceptionBuilderMap();

    public Exception transformException(Exception crtRuntimeException) {
        Optional<CrtS3RuntimeException> crtS3RuntimeExceptionOptional = this.getCrtS3RuntimeException(crtRuntimeException);
        Exception exception = crtS3RuntimeExceptionOptional.filter(CrtErrorHandler::isErrorDetailsAvailable).map(e -> this.getServiceSideException((CrtS3RuntimeException)e)).orElseGet(() -> SdkClientException.create((String)crtRuntimeException.getMessage(), (Throwable)crtRuntimeException));
        return exception;
    }

    private Exception getServiceSideException(CrtS3RuntimeException e) {
        if (this.s3ExceptionBuilderMap.get(e.getAwsErrorCode()) != null) {
            return this.s3ExceptionBuilderMap.get(e.getAwsErrorCode()).awsErrorDetails(AwsErrorDetails.builder().errorCode(e.getAwsErrorCode()).errorMessage(e.getAwsErrorMessage()).build()).cause((Throwable)e).message(e.getMessage()).statusCode(e.getStatusCode()).build();
        }
        return S3Exception.builder().statusCode(e.getStatusCode()).message(e.getMessage()).cause((Throwable)e).build();
    }

    private static boolean isErrorDetailsAvailable(CrtS3RuntimeException crtS3RuntimeException) {
        return StringUtils.isNotBlank((CharSequence)crtS3RuntimeException.getAwsErrorCode());
    }

    private Optional<CrtS3RuntimeException> getCrtS3RuntimeException(Exception crtRuntimeException) {
        if (crtRuntimeException instanceof CrtS3RuntimeException) {
            return Optional.of((CrtS3RuntimeException)crtRuntimeException);
        }
        Throwable cause = crtRuntimeException.getCause();
        if (cause instanceof CrtS3RuntimeException) {
            return Optional.of((CrtS3RuntimeException)cause);
        }
        return Optional.empty();
    }

    private Map<String, S3Exception.Builder> getS3ExceptionBuilderMap() {
        HashMap<String, S3Exception.Builder> s3ExceptionBuilderMap = new HashMap<String, S3Exception.Builder>();
        s3ExceptionBuilderMap.put("ObjectAlreadyInActiveTierError", (S3Exception.Builder)ObjectAlreadyInActiveTierErrorException.builder());
        s3ExceptionBuilderMap.put("NoSuchUpload", (S3Exception.Builder)NoSuchUploadException.builder());
        s3ExceptionBuilderMap.put("BucketAlreadyExists", (S3Exception.Builder)BucketAlreadyExistsException.builder());
        s3ExceptionBuilderMap.put("BucketAlreadyOwnedByYou", (S3Exception.Builder)BucketAlreadyOwnedByYouException.builder());
        s3ExceptionBuilderMap.put("InvalidObjectState", (S3Exception.Builder)InvalidObjectStateException.builder());
        s3ExceptionBuilderMap.put("NoSuchBucket", (S3Exception.Builder)NoSuchBucketException.builder());
        s3ExceptionBuilderMap.put("NoSuchKey", (S3Exception.Builder)NoSuchKeyException.builder());
        return s3ExceptionBuilderMap;
    }
}

