/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.transfer.s3.TransferRequest;
import software.amazon.awssdk.transfer.s3.TransferRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class DownloadRequest
implements TransferRequest,
ToCopyableBuilder<Builder, DownloadRequest> {
    private final Path destination;
    private final GetObjectRequest getObjectRequest;
    private final TransferRequestOverrideConfiguration overrideConfiguration;

    private DownloadRequest(BuilderImpl builder) {
        this.destination = (Path)Validate.paramNotNull((Object)builder.destination, (String)"destination");
        this.getObjectRequest = (GetObjectRequest)Validate.paramNotNull((Object)builder.getObjectRequest, (String)"getObjectRequest");
        this.overrideConfiguration = builder.configuration;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Builder toBuilder() {
        return new BuilderImpl();
    }

    public Path destination() {
        return this.destination;
    }

    public GetObjectRequest getObjectRequest() {
        return this.getObjectRequest;
    }

    public Optional<TransferRequestOverrideConfiguration> overrideConfiguration() {
        return Optional.ofNullable(this.overrideConfiguration);
    }

    public String toString() {
        return ToString.builder((String)"DownloadRequest").add("destination", (Object)this.destination).add("getObjectRequest", (Object)this.getObjectRequest).add("overrideConfiguration", (Object)this.overrideConfiguration).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadRequest that = (DownloadRequest)o;
        if (!Objects.equals(this.destination, that.destination)) {
            return false;
        }
        if (!Objects.equals(this.getObjectRequest, that.getObjectRequest)) {
            return false;
        }
        return Objects.equals(this.overrideConfiguration, that.overrideConfiguration);
    }

    public int hashCode() {
        int result = this.destination != null ? this.destination.hashCode() : 0;
        result = 31 * result + (this.getObjectRequest != null ? this.getObjectRequest.hashCode() : 0);
        result = 31 * result + (this.overrideConfiguration != null ? this.overrideConfiguration.hashCode() : 0);
        return result;
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    private static final class BuilderImpl
    implements Builder {
        private Path destination;
        private GetObjectRequest getObjectRequest;
        private TransferRequestOverrideConfiguration configuration;

        private BuilderImpl() {
        }

        @Override
        public Builder destination(Path destination) {
            this.destination = destination;
            return this;
        }

        public Path getDestination() {
            return this.destination;
        }

        public void setDestination(Path destination) {
            this.destination(destination);
        }

        @Override
        public Builder getObjectRequest(GetObjectRequest getObjectRequest) {
            this.getObjectRequest = getObjectRequest;
            return this;
        }

        public GetObjectRequest getGetObjectRequest() {
            return this.getObjectRequest;
        }

        public void setGetObjectRequest(GetObjectRequest getObjectRequest) {
            this.getObjectRequest(getObjectRequest);
        }

        @Override
        public Builder overrideConfiguration(TransferRequestOverrideConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public void setOverrideConfiguration(TransferRequestOverrideConfiguration configuration) {
            this.overrideConfiguration(configuration);
        }

        public TransferRequestOverrideConfiguration getOverrideConfiguration() {
            return this.configuration;
        }

        @Override
        public DownloadRequest build() {
            return new DownloadRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends TransferRequest.Builder<DownloadRequest, Builder>,
    CopyableBuilder<Builder, DownloadRequest> {
        public Builder destination(Path var1);

        default public Builder destination(File destination) {
            Validate.paramNotNull((Object)destination, (String)"destination");
            return this.destination(destination.toPath());
        }

        public Builder getObjectRequest(GetObjectRequest var1);

        default public Builder getObjectRequest(Consumer<GetObjectRequest.Builder> getObjectRequestBuilder) {
            GetObjectRequest request = (GetObjectRequest)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequestBuilder)).build();
            this.getObjectRequest(request);
            return this;
        }

        public Builder overrideConfiguration(TransferRequestOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<TransferRequestOverrideConfiguration.Builder> configurationBuilder) {
            Validate.paramNotNull(configurationBuilder, (String)"configurationBuilder");
            return this.overrideConfiguration(((TransferRequestOverrideConfiguration.Builder)TransferRequestOverrideConfiguration.builder().applyMutation(configurationBuilder)).build());
        }

        @Override
        public DownloadRequest build();
    }
}

