/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.transfer.s3.CompletedTransfer;
import software.amazon.awssdk.transfer.s3.DownloadRequest;
import software.amazon.awssdk.transfer.s3.TransferRequestOverrideConfiguration;
import software.amazon.awssdk.transfer.s3.UploadRequest;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgress;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgressSnapshot;
import software.amazon.awssdk.transfer.s3.internal.progress.NotifyingAsyncRequestBody;
import software.amazon.awssdk.transfer.s3.internal.progress.NotifyingAsyncResponseTransformer;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferListenerContext;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferListenerFailedContext;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferListenerInvoker;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;

@SdkInternalApi
public class TransferProgressUpdater {
    private final DefaultTransferProgress progress;
    private final TransferListenerContext context;
    private final TransferListenerInvoker listeners;

    public TransferProgressUpdater(UploadRequest request, AsyncRequestBody requestBody) {
        DefaultTransferProgressSnapshot.Builder snapshotBuilder = DefaultTransferProgressSnapshot.builder();
        TransferProgressUpdater.getContentLengthSafe(requestBody).ifPresent(snapshotBuilder::transferSizeInBytes);
        DefaultTransferProgressSnapshot snapshot = snapshotBuilder.build();
        this.progress = new DefaultTransferProgress(snapshot);
        this.context = TransferListenerContext.builder().request(request).progressSnapshot(snapshot).build();
        this.listeners = new TransferListenerInvoker(request.overrideConfiguration().map(TransferRequestOverrideConfiguration::listeners).orElseGet(Collections::emptyList));
    }

    public TransferProgressUpdater(DownloadRequest request) {
        DefaultTransferProgressSnapshot snapshot = DefaultTransferProgressSnapshot.builder().build();
        this.progress = new DefaultTransferProgress(snapshot);
        this.context = TransferListenerContext.builder().request(request).progressSnapshot(snapshot).build();
        this.listeners = new TransferListenerInvoker(request.overrideConfiguration().map(TransferRequestOverrideConfiguration::listeners).orElseGet(Collections::emptyList));
    }

    public TransferProgress progress() {
        return this.progress;
    }

    public void transferInitiated() {
        this.listeners.transferInitiated(this.context);
    }

    public AsyncRequestBody wrapRequestBody(AsyncRequestBody requestBody) {
        return new NotifyingAsyncRequestBody(requestBody, new NotifyingAsyncRequestBody.AsyncRequestBodyListener(){

            @Override
            public void beforeSubscribe(Subscriber<? super ByteBuffer> subscriber) {
                TransferProgressUpdater.this.progress.updateAndGet(b -> b.bytesTransferred(0L));
            }

            @Override
            public void beforeOnNext(ByteBuffer byteBuffer) {
                TransferProgressSnapshot snapshot = TransferProgressUpdater.this.progress.updateAndGet(b -> b.bytesTransferred(b.getBytesTransferred() + (long)byteBuffer.limit()));
                TransferProgressUpdater.this.listeners.bytesTransferred((TransferListener.Context.BytesTransferred)TransferProgressUpdater.this.context.copy(b -> b.progressSnapshot(snapshot)));
            }
        });
    }

    public AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> wrapResponseTransformer(AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> responseTransformer) {
        return new NotifyingAsyncResponseTransformer<GetObjectResponse, GetObjectResponse>(responseTransformer, new NotifyingAsyncResponseTransformer.AsyncResponseTransformerListener<GetObjectResponse, GetObjectResponse>(){

            @Override
            public void beforeOnResponse(GetObjectResponse response) {
                if (response.contentLength() != null) {
                    TransferProgressUpdater.this.progress.updateAndGet(b -> b.transferSizeInBytes(response.contentLength()));
                }
            }

            @Override
            public void beforeSubscribe(Subscriber<? super ByteBuffer> subscriber) {
                TransferProgressUpdater.this.progress.updateAndGet(b -> b.bytesTransferred(0L));
            }

            @Override
            public void beforeOnNext(ByteBuffer byteBuffer) {
                TransferProgressSnapshot snapshot = TransferProgressUpdater.this.progress.updateAndGet(b -> b.bytesTransferred(b.getBytesTransferred() + (long)byteBuffer.limit()));
                TransferProgressUpdater.this.listeners.bytesTransferred((TransferListener.Context.BytesTransferred)TransferProgressUpdater.this.context.copy(b -> b.progressSnapshot(snapshot)));
            }
        });
    }

    public void registerCompletion(CompletableFuture<? extends CompletedTransfer> future) {
        future.whenComplete((r, t) -> {
            if (t == null) {
                this.listeners.transferComplete((TransferListener.Context.TransferComplete)this.context.copy(b -> {
                    b.progressSnapshot(this.progress.snapshot());
                    b.completedTransfer((CompletedTransfer)r);
                }));
            } else {
                this.listeners.transferFailed(TransferListenerFailedContext.builder().transferContext((TransferListenerContext)this.context.copy(b -> b.progressSnapshot(this.progress.snapshot()))).exception((Throwable)t).build());
            }
        });
    }

    private static Optional<Long> getContentLengthSafe(AsyncRequestBody requestBody) {
        try {
            return requestBody.contentLength();
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }
}

