/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;

@SdkInternalApi
public class NotifyingAsyncResponseTransformer<ResponseT, ResultT>
implements AsyncResponseTransformer<ResponseT, ResultT> {
    private final AsyncResponseTransformer<ResponseT, ResultT> delegate;
    private final AsyncResponseTransformerListener<ResponseT, ResultT> listener;

    public NotifyingAsyncResponseTransformer(AsyncResponseTransformer<ResponseT, ResultT> delegate, AsyncResponseTransformerListener<ResponseT, ResultT> listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public CompletableFuture<ResultT> prepare() {
        return this.delegate.prepare();
    }

    public void onResponse(ResponseT response) {
        this.listener.beforeOnResponse(response);
        this.delegate.onResponse(response);
    }

    public void onStream(SdkPublisher<ByteBuffer> publisher) {
        this.delegate.onStream(new NotifyingPublisher<ResponseT, ResultT>(publisher, this.listener));
    }

    public void exceptionOccurred(Throwable error) {
        this.delegate.exceptionOccurred(error);
    }

    @SdkInternalApi
    private static final class NotifyingSubscriber<ResponseT, ResultT>
    implements Subscriber<ByteBuffer> {
        private final Subscriber<? super ByteBuffer> delegate;
        private final AsyncResponseTransformerListener<ResponseT, ResultT> listener;

        NotifyingSubscriber(Subscriber<? super ByteBuffer> delegate, AsyncResponseTransformerListener<ResponseT, ResultT> listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        public void onSubscribe(Subscription s) {
            this.delegate.onSubscribe(s);
        }

        public void onNext(ByteBuffer byteBuffer) {
            this.listener.beforeOnNext(byteBuffer);
            this.delegate.onNext((Object)byteBuffer);
        }

        public void onError(Throwable t) {
            this.delegate.onError(t);
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }

    @SdkInternalApi
    private static final class NotifyingPublisher<ResponseT, ResultT>
    implements SdkPublisher<ByteBuffer> {
        private final SdkPublisher<ByteBuffer> delegate;
        private final AsyncResponseTransformerListener<ResponseT, ResultT> listener;

        NotifyingPublisher(SdkPublisher<ByteBuffer> delegate, AsyncResponseTransformerListener<ResponseT, ResultT> listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        public void subscribe(Subscriber<? super ByteBuffer> s) {
            this.listener.beforeSubscribe(s);
            this.delegate.subscribe(new NotifyingSubscriber<ResponseT, ResultT>(s, this.listener));
        }
    }

    public static interface AsyncResponseTransformerListener<ResponseT, ResultT> {
        default public void beforeOnResponse(ResponseT response) {
        }

        default public void beforeSubscribe(Subscriber<? super ByteBuffer> subscriber) {
        }

        default public void beforeOnNext(ByteBuffer byteBuffer) {
        }
    }
}

