/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;

@SdkInternalApi
public class NotifyingAsyncRequestBody
implements AsyncRequestBody {
    private final AsyncRequestBody delegate;
    private final AsyncRequestBodyListener listener;

    public NotifyingAsyncRequestBody(AsyncRequestBody delegate, AsyncRequestBodyListener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public Optional<Long> contentLength() {
        return this.delegate.contentLength();
    }

    public String contentType() {
        return this.delegate.contentType();
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        this.listener.beforeSubscribe(subscriber);
        this.delegate.subscribe((Subscriber)new NotifyingSubscriber(subscriber, this.listener));
    }

    @SdkInternalApi
    private static final class NotifyingSubscriber
    implements Subscriber<ByteBuffer> {
        private final Subscriber<? super ByteBuffer> delegate;
        private final AsyncRequestBodyListener listener;

        NotifyingSubscriber(Subscriber<? super ByteBuffer> delegate, AsyncRequestBodyListener listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        public void onSubscribe(Subscription s) {
            this.delegate.onSubscribe(s);
        }

        public void onNext(ByteBuffer byteBuffer) {
            this.listener.beforeOnNext(byteBuffer);
            this.delegate.onNext((Object)byteBuffer);
        }

        public void onError(Throwable t) {
            this.delegate.onError(t);
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }

    public static interface AsyncRequestBodyListener {
        default public void beforeSubscribe(Subscriber<? super ByteBuffer> subscriber) {
        }

        default public void beforeOnNext(ByteBuffer byteBuffer) {
        }
    }
}

