/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.transfer.s3.TransferRequest;
import software.amazon.awssdk.transfer.s3.TransferRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class UploadRequest
implements TransferRequest,
ToCopyableBuilder<Builder, UploadRequest> {
    private final PutObjectRequest putObjectRequest;
    private final Path source;
    private final TransferRequestOverrideConfiguration overrideConfiguration;

    private UploadRequest(BuilderImpl builder) {
        this.putObjectRequest = (PutObjectRequest)Validate.paramNotNull((Object)builder.putObjectRequest, (String)"putObjectRequest");
        this.source = (Path)Validate.paramNotNull((Object)builder.source, (String)"source");
        this.overrideConfiguration = builder.configuration;
    }

    public PutObjectRequest putObjectRequest() {
        return this.putObjectRequest;
    }

    public Path source() {
        return this.source;
    }

    public Optional<TransferRequestOverrideConfiguration> overrideConfiguration() {
        return Optional.ofNullable(this.overrideConfiguration);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public Builder toBuilder() {
        return new BuilderImpl();
    }

    public String toString() {
        return ToString.builder((String)"UploadRequest").add("putObjectRequest", (Object)this.putObjectRequest).add("source", (Object)this.source).add("overrideConfiguration", (Object)this.overrideConfiguration).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadRequest that = (UploadRequest)o;
        if (!Objects.equals(this.putObjectRequest, that.putObjectRequest)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        return Objects.equals(this.overrideConfiguration, that.overrideConfiguration);
    }

    public int hashCode() {
        int result = this.putObjectRequest != null ? this.putObjectRequest.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.overrideConfiguration != null ? this.overrideConfiguration.hashCode() : 0);
        return result;
    }

    private static class BuilderImpl
    implements Builder {
        private PutObjectRequest putObjectRequest;
        private Path source;
        private TransferRequestOverrideConfiguration configuration;

        private BuilderImpl() {
        }

        @Override
        public Builder source(Path source) {
            this.source = source;
            return this;
        }

        public Path getSource() {
            return this.source;
        }

        public void setSource(Path source) {
            this.source(source);
        }

        @Override
        public Builder putObjectRequest(PutObjectRequest putObjectRequest) {
            this.putObjectRequest = putObjectRequest;
            return this;
        }

        public PutObjectRequest getPutObjectRequest() {
            return this.putObjectRequest;
        }

        public void setPutObjectRequest(PutObjectRequest putObjectRequest) {
            this.putObjectRequest(putObjectRequest);
        }

        @Override
        public Builder overrideConfiguration(TransferRequestOverrideConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public void setOverrideConfiguration(TransferRequestOverrideConfiguration configuration) {
            this.overrideConfiguration(configuration);
        }

        public TransferRequestOverrideConfiguration getOverrideConfiguration() {
            return this.configuration;
        }

        @Override
        public UploadRequest build() {
            return new UploadRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends TransferRequest.Builder<UploadRequest, Builder>,
    CopyableBuilder<Builder, UploadRequest> {
        public Builder source(Path var1);

        default public Builder source(File source) {
            Validate.paramNotNull((Object)source, (String)"source");
            return this.source(source.toPath());
        }

        public Builder putObjectRequest(PutObjectRequest var1);

        default public Builder putObjectRequest(Consumer<PutObjectRequest.Builder> putObjectRequestBuilder) {
            return this.putObjectRequest((PutObjectRequest)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequestBuilder)).build());
        }

        public Builder overrideConfiguration(TransferRequestOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<TransferRequestOverrideConfiguration.Builder> configurationBuilder) {
            Validate.paramNotNull(configurationBuilder, (String)"configurationBuilder");
            return this.overrideConfiguration(((TransferRequestOverrideConfiguration.Builder)TransferRequestOverrideConfiguration.builder().applyMutation(configurationBuilder)).build());
        }

        @Override
        public UploadRequest build();
    }
}

