/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.UploadFileRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class UploadDirectoryOverrideConfiguration
implements ToCopyableBuilder<Builder, UploadDirectoryOverrideConfiguration> {
    private final Boolean followSymbolicLinks;
    private final Integer maxDepth;
    private final Boolean recursive;
    private final Consumer<UploadFileRequest.Builder> uploadFileRequestTransformer;

    public UploadDirectoryOverrideConfiguration(DefaultBuilder builder) {
        this.followSymbolicLinks = builder.followSymbolicLinks;
        this.maxDepth = Validate.isPositiveOrNull((Integer)builder.maxDepth, (String)"maxDepth");
        this.recursive = builder.recursive;
        this.uploadFileRequestTransformer = builder.uploadFileRequestTransformer;
    }

    public Optional<Boolean> followSymbolicLinks() {
        return Optional.ofNullable(this.followSymbolicLinks);
    }

    public Optional<Integer> maxDepth() {
        return Optional.ofNullable(this.maxDepth);
    }

    public Optional<Boolean> recursive() {
        return Optional.ofNullable(this.recursive);
    }

    public Consumer<UploadFileRequest.Builder> uploadFileRequestTransformer() {
        return this.uploadFileRequestTransformer == null ? ignore -> {} : this.uploadFileRequestTransformer;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadDirectoryOverrideConfiguration that = (UploadDirectoryOverrideConfiguration)o;
        if (!Objects.equals(this.followSymbolicLinks, that.followSymbolicLinks)) {
            return false;
        }
        if (!Objects.equals(this.maxDepth, that.maxDepth)) {
            return false;
        }
        if (!Objects.equals(this.uploadFileRequestTransformer, that.uploadFileRequestTransformer)) {
            return false;
        }
        return Objects.equals(this.recursive, that.recursive);
    }

    public int hashCode() {
        int result = this.followSymbolicLinks != null ? this.followSymbolicLinks.hashCode() : 0;
        result = 31 * result + (this.maxDepth != null ? this.maxDepth.hashCode() : 0);
        result = 31 * result + (this.recursive != null ? this.recursive.hashCode() : 0);
        result = 31 * result + (this.uploadFileRequestTransformer != null ? this.uploadFileRequestTransformer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"UploadDirectoryConfiguration").add("followSymbolicLinks", (Object)this.followSymbolicLinks).add("maxDepth", (Object)this.maxDepth).add("recursive", (Object)this.recursive).add("uploadFileRequestTransformer", this.uploadFileRequestTransformer).build();
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    private static final class DefaultBuilder
    implements Builder {
        private Boolean followSymbolicLinks;
        private Integer maxDepth;
        private Boolean recursive;
        private Consumer<UploadFileRequest.Builder> uploadFileRequestTransformer;

        private DefaultBuilder(UploadDirectoryOverrideConfiguration configuration) {
            this.followSymbolicLinks = configuration.followSymbolicLinks;
            this.maxDepth = configuration.maxDepth;
            this.recursive = configuration.recursive;
            this.uploadFileRequestTransformer = configuration.uploadFileRequestTransformer;
        }

        private DefaultBuilder() {
        }

        @Override
        public Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Boolean getRecursive() {
            return this.recursive;
        }

        public void setRecursive(Boolean recursive) {
            this.recursive(recursive);
        }

        @Override
        public Builder followSymbolicLinks(Boolean followSymbolicLinks) {
            this.followSymbolicLinks = followSymbolicLinks;
            return this;
        }

        public void setFollowSymbolicLinks(Boolean followSymbolicLinks) {
            this.followSymbolicLinks(followSymbolicLinks);
        }

        public Boolean getFollowSymbolicLinks() {
            return this.followSymbolicLinks;
        }

        @Override
        public Builder maxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public void setMaxDepth(Integer maxDepth) {
            this.maxDepth(maxDepth);
        }

        public Integer getMaxDepth() {
            return this.maxDepth;
        }

        @Override
        public Builder uploadFileRequestTransformer(Consumer<UploadFileRequest.Builder> uploadFileRequestTransformer) {
            this.uploadFileRequestTransformer = uploadFileRequestTransformer;
            return this;
        }

        public Consumer<UploadFileRequest.Builder> getUploadFileRequestTransformer() {
            return this.uploadFileRequestTransformer;
        }

        public void setUploadFileRequestTransformer(Consumer<UploadFileRequest.Builder> uploadFileRequestTransformer) {
            this.uploadFileRequestTransformer = uploadFileRequestTransformer;
        }

        @Override
        public UploadDirectoryOverrideConfiguration build() {
            return new UploadDirectoryOverrideConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadDirectoryOverrideConfiguration> {
        public Builder recursive(Boolean var1);

        public Builder followSymbolicLinks(Boolean var1);

        public Builder maxDepth(Integer var1);

        public Builder uploadFileRequestTransformer(Consumer<UploadFileRequest.Builder> var1);

        public UploadDirectoryOverrideConfiguration build();
    }
}

