/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.DownloadFilter;
import software.amazon.awssdk.transfer.s3.TransferDirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class DownloadDirectoryRequest
implements TransferDirectoryRequest,
ToCopyableBuilder<Builder, DownloadDirectoryRequest> {
    private final Path destinationDirectory;
    private final String bucket;
    private final String prefix;
    private final String delimiter;
    private final DownloadFilter filter;

    public DownloadDirectoryRequest(DefaultBuilder builder) {
        this.destinationDirectory = (Path)Validate.paramNotNull((Object)builder.destinationDirectory, (String)"destinationDirectory");
        this.bucket = (String)Validate.paramNotNull((Object)builder.bucket, (String)"bucket");
        this.prefix = builder.prefix;
        this.delimiter = builder.delimiter;
        this.filter = builder.filter;
    }

    public Path destinationDirectory() {
        return this.destinationDirectory;
    }

    public String bucket() {
        return this.bucket;
    }

    public Optional<String> prefix() {
        return Optional.ofNullable(this.prefix);
    }

    public Optional<String> delimiter() {
        return Optional.ofNullable(this.delimiter);
    }

    public DownloadFilter filter() {
        return this.filter == null ? DownloadFilter.allObjects() : this.filter;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadDirectoryRequest that = (DownloadDirectoryRequest)o;
        if (!Objects.equals(this.destinationDirectory, that.destinationDirectory)) {
            return false;
        }
        if (!Objects.equals(this.bucket, that.bucket)) {
            return false;
        }
        if (!Objects.equals(this.prefix, that.prefix)) {
            return false;
        }
        if (!Objects.equals(this.delimiter, that.delimiter)) {
            return false;
        }
        return Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        int result = this.destinationDirectory != null ? this.destinationDirectory.hashCode() : 0;
        result = 31 * result + (this.bucket != null ? this.bucket.hashCode() : 0);
        result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        result = 31 * result + (this.delimiter != null ? this.delimiter.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DownloadDirectoryRequest").add("destinationDirectory", (Object)this.destinationDirectory).add("bucket", (Object)this.bucket).add("prefix", (Object)this.prefix).add("delimiter", (Object)this.delimiter).add("filter", (Object)this.filter).build();
    }

    private static final class DefaultBuilder
    implements Builder {
        private Path destinationDirectory;
        private String bucket;
        private String prefix;
        private String delimiter;
        private DownloadFilter filter;

        private DefaultBuilder() {
        }

        private DefaultBuilder(DownloadDirectoryRequest request) {
            this.destinationDirectory = request.destinationDirectory;
            this.bucket = request.bucket;
            this.prefix = request.prefix;
            this.filter = request.filter;
        }

        @Override
        public Builder destinationDirectory(Path destinationDirectory) {
            this.destinationDirectory = destinationDirectory;
            return this;
        }

        public void setDestinationDirectory(Path destinationDirectory) {
            this.destinationDirectory(destinationDirectory);
        }

        public Path getDestinationDirectory() {
            return this.destinationDirectory;
        }

        @Override
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public void setBucket(String bucket) {
            this.bucket(bucket);
        }

        public String getBucket() {
            return this.bucket;
        }

        @Override
        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public void setPrefix(String prefix) {
            this.prefix(prefix);
        }

        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter(delimiter);
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public Builder filter(DownloadFilter filter) {
            this.filter = filter;
            return this;
        }

        public void setFilter(DownloadFilter filter) {
            this.filter(filter);
        }

        public DownloadFilter getFilter() {
            return this.filter;
        }

        public DownloadDirectoryRequest build() {
            return new DownloadDirectoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DownloadDirectoryRequest> {
        public Builder destinationDirectory(Path var1);

        public Builder bucket(String var1);

        public Builder prefix(String var1);

        public Builder delimiter(String var1);

        public Builder filter(DownloadFilter var1);
    }
}

