/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventnotifications.s3.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.eventnotifications.s3.internal.S3EventNotificationReader;
import software.amazon.awssdk.eventnotifications.s3.model.GlacierEventData;
import software.amazon.awssdk.eventnotifications.s3.model.IntelligentTieringEventData;
import software.amazon.awssdk.eventnotifications.s3.model.LifecycleEventData;
import software.amazon.awssdk.eventnotifications.s3.model.ReplicationEventData;
import software.amazon.awssdk.eventnotifications.s3.model.RequestParameters;
import software.amazon.awssdk.eventnotifications.s3.model.ResponseElements;
import software.amazon.awssdk.eventnotifications.s3.model.RestoreEventData;
import software.amazon.awssdk.eventnotifications.s3.model.S3;
import software.amazon.awssdk.eventnotifications.s3.model.S3Bucket;
import software.amazon.awssdk.eventnotifications.s3.model.S3EventNotification;
import software.amazon.awssdk.eventnotifications.s3.model.S3EventNotificationRecord;
import software.amazon.awssdk.eventnotifications.s3.model.S3Object;
import software.amazon.awssdk.eventnotifications.s3.model.TransitionEventData;
import software.amazon.awssdk.eventnotifications.s3.model.UserIdentity;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultS3EventNotificationReader
implements S3EventNotificationReader {
    private static final JsonNodeParser JSON_NODE_PARSER = JsonNodeParser.create();

    @Override
    public S3EventNotification read(String event) {
        return this.read(event.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public S3EventNotification read(byte[] event) {
        return this.read(new ByteArrayInputStream(event));
    }

    @Override
    public S3EventNotification read(InputStream event) {
        return this.readEvent(JSON_NODE_PARSER.parse(event));
    }

    private S3EventNotification readEvent(JsonNode jsonNode) {
        Map<String, JsonNode> records = this.expectObjectOrNull(jsonNode, "Records");
        if (records == null) {
            return new S3EventNotification(null);
        }
        return new S3EventNotification(this.readRecords(records.get("Records")));
    }

    private List<S3EventNotificationRecord> readRecords(JsonNode node) {
        if (DefaultS3EventNotificationReader.isNull(node)) {
            return null;
        }
        List<JsonNode> recordArray = this.expectArrayOrNull(node, "Records");
        if (recordArray == null) {
            return Collections.emptyList();
        }
        return recordArray.stream().map(this::readEventNotificationRecord).collect(Collectors.toList());
    }

    private S3EventNotificationRecord readEventNotificationRecord(JsonNode jsonNode) {
        Map<String, JsonNode> recordNode = this.expectObjectOrNull(jsonNode, "Records[]");
        if (recordNode == null) {
            return null;
        }
        S3EventNotificationRecord eventNotificationRecord = new S3EventNotificationRecord();
        String eventVersion = this.expectStringOrNull(recordNode, "eventVersion");
        eventNotificationRecord.setEventVersion(eventVersion);
        String awsRegion = this.expectStringOrNull(recordNode, "awsRegion");
        eventNotificationRecord.setAwsRegion(awsRegion);
        String eventName = this.expectStringOrNull(recordNode, "eventName");
        eventNotificationRecord.setEventName(eventName);
        String eventSource = this.expectStringOrNull(recordNode, "eventSource");
        eventNotificationRecord.setEventSource(eventSource);
        String eventTime = this.expectStringOrNull(recordNode, "eventTime");
        eventNotificationRecord.setEventTime(eventName != null ? Instant.parse(eventTime) : null);
        RequestParameters requestParameters = this.readRequestParameters(recordNode.get("requestParameters"));
        eventNotificationRecord.setRequestParameters(requestParameters);
        ResponseElements responseElements = this.readResponseElements(recordNode.get("responseElements"));
        eventNotificationRecord.setResponseElements(responseElements);
        S3 s3 = this.readS3(recordNode.get("s3"));
        eventNotificationRecord.setS3(s3);
        UserIdentity userIdentity = this.readUserIdentity(recordNode.get("userIdentity"));
        eventNotificationRecord.setUserIdentity(userIdentity);
        GlacierEventData glacierEventData = this.readGlacierEventData(recordNode.get("glacierEventData"));
        eventNotificationRecord.setGlacierEventData(glacierEventData);
        LifecycleEventData lifecycleEventData = this.readLifecycleEventData(recordNode.get("lifecycleEventData"));
        eventNotificationRecord.setLifecycleEventData(lifecycleEventData);
        IntelligentTieringEventData intelligentTieringEventData = this.readIntelligentTieringEventData(recordNode.get("intelligentTieringEventData"));
        eventNotificationRecord.setIntelligentTieringEventData(intelligentTieringEventData);
        ReplicationEventData replicationEventData = this.readReplicationEventData(recordNode.get("replicationEventData"));
        eventNotificationRecord.setReplicationEventData(replicationEventData);
        return eventNotificationRecord;
    }

    private ReplicationEventData readReplicationEventData(JsonNode jsonNode) {
        Map<String, JsonNode> replicationDataNode = this.expectObjectOrNull(jsonNode, "replicationEventData");
        if (replicationDataNode == null) {
            return null;
        }
        String replicationRuleId = this.expectStringOrNull(replicationDataNode, "replicationRuleId");
        String destinationBucket = this.expectStringOrNull(replicationDataNode, "destinationBucket");
        String s3Operation = this.expectStringOrNull(replicationDataNode, "s3Operation");
        String requestTime = this.expectStringOrNull(replicationDataNode, "requestTime");
        String failureReason = this.expectStringOrNull(replicationDataNode, "failureReason");
        String threshold = this.expectStringOrNull(replicationDataNode, "threshold");
        String replicationTime = this.expectStringOrNull(replicationDataNode, "replicationTime");
        return new ReplicationEventData(replicationRuleId, destinationBucket, s3Operation, requestTime, failureReason, threshold, replicationTime);
    }

    private IntelligentTieringEventData readIntelligentTieringEventData(JsonNode jsonNode) {
        Map<String, JsonNode> lifeCycleEventDataNode = this.expectObjectOrNull(jsonNode, "intelligentTieringEventData");
        if (lifeCycleEventDataNode == null) {
            return null;
        }
        String destinationAccessTier = this.expectStringOrNull(lifeCycleEventDataNode, "destinationAccessTier");
        return new IntelligentTieringEventData(destinationAccessTier);
    }

    private LifecycleEventData readLifecycleEventData(JsonNode jsonNode) {
        Map<String, JsonNode> lifeCycleEventDataNode = this.expectObjectOrNull(jsonNode, "lifecycleEventData");
        if (lifeCycleEventDataNode == null) {
            return null;
        }
        Map<String, JsonNode> transitionEventDataNode = this.expectObjectOrNull(lifeCycleEventDataNode.get("transitionEventData"), "transitionEventData");
        if (transitionEventDataNode == null) {
            return new LifecycleEventData(null);
        }
        String destinationStorageClass = this.expectStringOrNull(transitionEventDataNode, "destinationStorageClass");
        return new LifecycleEventData(new TransitionEventData(destinationStorageClass));
    }

    private GlacierEventData readGlacierEventData(JsonNode jsonNode) {
        Map<String, JsonNode> glacierEventDataNode = this.expectObjectOrNull(jsonNode, "glacierEventData");
        if (glacierEventDataNode == null) {
            return null;
        }
        Map<String, JsonNode> restoreEventDataNode = this.expectObjectOrNull(glacierEventDataNode.get("restoreEventData"), "restoreEventData");
        if (restoreEventDataNode == null) {
            return new GlacierEventData(null);
        }
        String lifecycleRestorationExpiryTime = this.expectStringOrNull(restoreEventDataNode, "lifecycleRestorationExpiryTime");
        String lifecycleRestoreStorageClass = this.expectStringOrNull(restoreEventDataNode, "lifecycleRestoreStorageClass");
        return new GlacierEventData(new RestoreEventData(lifecycleRestorationExpiryTime, lifecycleRestoreStorageClass));
    }

    private UserIdentity readUserIdentity(JsonNode jsonNode) {
        Map<String, JsonNode> userIdentityNode = this.expectObjectOrNull(jsonNode, "userIdentity");
        if (userIdentityNode == null) {
            return null;
        }
        String principalId = this.expectStringOrNull(userIdentityNode, "principalId");
        return new UserIdentity(principalId);
    }

    private S3 readS3(JsonNode jsonNode) {
        Map<String, JsonNode> s3 = this.expectObjectOrNull(jsonNode, "s3");
        if (s3 == null) {
            return null;
        }
        String configurationId = this.expectStringOrNull(s3, "configurationId");
        S3Bucket bucket = this.readBucket(s3.get("bucket"));
        S3Object object = this.readObject(s3.get("object"));
        String s3SchemaVersion = this.expectStringOrNull(s3, "s3SchemaVersion");
        return new S3(configurationId, bucket, object, s3SchemaVersion);
    }

    private S3Object readObject(JsonNode jsonNode) {
        Map<String, JsonNode> objectNode = this.expectObjectOrNull(jsonNode, "object");
        if (objectNode == null) {
            return null;
        }
        String key = this.expectStringOrNull(objectNode, "key");
        Long size = this.expectLong(objectNode.get("size"), "size");
        String eTag = this.expectStringOrNull(objectNode, "eTag");
        String versionId = this.expectStringOrNull(objectNode, "versionId");
        String sequencer = this.expectStringOrNull(objectNode, "sequencer");
        return new S3Object(key, size, eTag, versionId, sequencer);
    }

    private S3Bucket readBucket(JsonNode jsonNode) {
        Map<String, JsonNode> bucketNode = this.expectObjectOrNull(jsonNode, "bucket");
        if (bucketNode == null) {
            return null;
        }
        String name = this.expectStringOrNull(bucketNode, "name");
        UserIdentity ownerIdentity = this.readOwnerIdentity(bucketNode.get("ownerIdentity"));
        String arn = this.expectStringOrNull(bucketNode, "arn");
        return new S3Bucket(name, ownerIdentity, arn);
    }

    private UserIdentity readOwnerIdentity(JsonNode jsonNode) {
        Map<String, JsonNode> ownerIdentityNode = this.expectObjectOrNull(jsonNode, "ownerIdentity");
        if (ownerIdentityNode == null) {
            return null;
        }
        String principalId = this.expectStringOrNull(ownerIdentityNode, "principalId");
        return new UserIdentity(principalId);
    }

    private ResponseElements readResponseElements(JsonNode jsonNode) {
        Map<String, JsonNode> responseElementNode = this.expectObjectOrNull(jsonNode, "responseElements");
        if (responseElementNode == null) {
            return null;
        }
        String requestId = this.expectStringOrNull(responseElementNode, "x-amz-request-id");
        String id2 = this.expectStringOrNull(responseElementNode, "x-amz-id-2");
        return new ResponseElements(id2, requestId);
    }

    private RequestParameters readRequestParameters(JsonNode jsonNode) {
        Map<String, JsonNode> requestParametersNode = this.expectObjectOrNull(jsonNode, "requestParameters");
        if (requestParametersNode == null) {
            return null;
        }
        String sourceIpAddressString = this.expectStringOrNull(requestParametersNode, "sourceIPAddress");
        return new RequestParameters(sourceIpAddressString);
    }

    private String expectStringOrNull(Map<String, JsonNode> node, String name) {
        return this.expectStringOrNull(node.get(name), name);
    }

    private String expectStringOrNull(JsonNode node, String name) {
        if (DefaultS3EventNotificationReader.isNull(node)) {
            return null;
        }
        Validate.isTrue((boolean)node.isString(), (String)"'%s' was not a string", (Object[])new Object[]{name});
        return node.asString();
    }

    private static boolean isNull(JsonNode node) {
        return node == null || node.isNull();
    }

    private List<JsonNode> expectArrayOrNull(JsonNode node, String name) {
        if (DefaultS3EventNotificationReader.isNull(node)) {
            return null;
        }
        Validate.isTrue((boolean)node.isArray(), (String)"expected '%s' to be an array, but was not.", (Object[])new Object[]{name});
        return node.asArray();
    }

    private Map<String, JsonNode> expectObjectOrNull(JsonNode node, String name) {
        if (DefaultS3EventNotificationReader.isNull(node)) {
            return null;
        }
        return this.expectObject(node, name);
    }

    private Map<String, JsonNode> expectObject(JsonNode node, String name) {
        Validate.isTrue((boolean)node.isObject(), (String)"expected '%s' to be an object, but was not.", (Object[])new Object[]{name});
        return node.asObject();
    }

    private Long expectLong(JsonNode node, String name) {
        if (DefaultS3EventNotificationReader.isNull(node)) {
            return null;
        }
        Validate.isTrue((boolean)node.isNumber(), (String)"expected '%s' to be numeric, but was not", (Object[])new Object[]{name});
        return Long.parseLong(node.asNumber());
    }
}

