/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeobfuscationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeobfuscationConfiguration.Builder, DeobfuscationConfiguration> {
    private static final SdkField<JavaScriptSourceMaps> JAVA_SCRIPT_SOURCE_MAPS_FIELD = SdkField
            .<JavaScriptSourceMaps> builder(MarshallingType.SDK_POJO).memberName("JavaScriptSourceMaps")
            .getter(getter(DeobfuscationConfiguration::javaScriptSourceMaps)).setter(setter(Builder::javaScriptSourceMaps))
            .constructor(JavaScriptSourceMaps::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JavaScriptSourceMaps").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(JAVA_SCRIPT_SOURCE_MAPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final JavaScriptSourceMaps javaScriptSourceMaps;

    private DeobfuscationConfiguration(BuilderImpl builder) {
        this.javaScriptSourceMaps = builder.javaScriptSourceMaps;
    }

    /**
     * <p>
     * A structure that contains the configuration for how an app monitor can unminify JavaScript error stack traces
     * using source maps.
     * </p>
     * 
     * @return A structure that contains the configuration for how an app monitor can unminify JavaScript error stack
     *         traces using source maps.
     */
    public final JavaScriptSourceMaps javaScriptSourceMaps() {
        return javaScriptSourceMaps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(javaScriptSourceMaps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeobfuscationConfiguration)) {
            return false;
        }
        DeobfuscationConfiguration other = (DeobfuscationConfiguration) obj;
        return Objects.equals(javaScriptSourceMaps(), other.javaScriptSourceMaps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeobfuscationConfiguration").add("JavaScriptSourceMaps", javaScriptSourceMaps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JavaScriptSourceMaps":
            return Optional.ofNullable(clazz.cast(javaScriptSourceMaps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JavaScriptSourceMaps", JAVA_SCRIPT_SOURCE_MAPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeobfuscationConfiguration, T> g) {
        return obj -> g.apply((DeobfuscationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeobfuscationConfiguration> {
        /**
         * <p>
         * A structure that contains the configuration for how an app monitor can unminify JavaScript error stack traces
         * using source maps.
         * </p>
         * 
         * @param javaScriptSourceMaps
         *        A structure that contains the configuration for how an app monitor can unminify JavaScript error stack
         *        traces using source maps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder javaScriptSourceMaps(JavaScriptSourceMaps javaScriptSourceMaps);

        /**
         * <p>
         * A structure that contains the configuration for how an app monitor can unminify JavaScript error stack traces
         * using source maps.
         * </p>
         * This is a convenience method that creates an instance of the {@link JavaScriptSourceMaps.Builder} avoiding
         * the need to create one manually via {@link JavaScriptSourceMaps#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JavaScriptSourceMaps.Builder#build()} is called immediately and
         * its result is passed to {@link #javaScriptSourceMaps(JavaScriptSourceMaps)}.
         * 
         * @param javaScriptSourceMaps
         *        a consumer that will call methods on {@link JavaScriptSourceMaps.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #javaScriptSourceMaps(JavaScriptSourceMaps)
         */
        default Builder javaScriptSourceMaps(Consumer<JavaScriptSourceMaps.Builder> javaScriptSourceMaps) {
            return javaScriptSourceMaps(JavaScriptSourceMaps.builder().applyMutation(javaScriptSourceMaps).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JavaScriptSourceMaps javaScriptSourceMaps;

        private BuilderImpl() {
        }

        private BuilderImpl(DeobfuscationConfiguration model) {
            javaScriptSourceMaps(model.javaScriptSourceMaps);
        }

        public final JavaScriptSourceMaps.Builder getJavaScriptSourceMaps() {
            return javaScriptSourceMaps != null ? javaScriptSourceMaps.toBuilder() : null;
        }

        public final void setJavaScriptSourceMaps(JavaScriptSourceMaps.BuilderImpl javaScriptSourceMaps) {
            this.javaScriptSourceMaps = javaScriptSourceMaps != null ? javaScriptSourceMaps.build() : null;
        }

        @Override
        public final Builder javaScriptSourceMaps(JavaScriptSourceMaps javaScriptSourceMaps) {
            this.javaScriptSourceMaps = javaScriptSourceMaps;
            return this;
        }

        @Override
        public DeobfuscationConfiguration build() {
            return new DeobfuscationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
