/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteResourcePolicyRequest extends RumRequest implements
        ToCopyableBuilder<DeleteResourcePolicyRequest.Builder, DeleteResourcePolicyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DeleteResourcePolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> POLICY_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyRevisionId").getter(getter(DeleteResourcePolicyRequest::policyRevisionId))
            .setter(setter(Builder::policyRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("policyRevisionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            POLICY_REVISION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String policyRevisionId;

    private DeleteResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.policyRevisionId = builder.policyRevisionId;
    }

    /**
     * <p>
     * The app monitor that you want to remove the resource policy from.
     * </p>
     * 
     * @return The app monitor that you want to remove the resource policy from.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies a specific policy revision to delete. Provide a <code>PolicyRevisionId</code> to ensure an atomic
     * delete operation. If the revision ID that you provide doesn't match the latest policy revision ID, the request
     * will be rejected with an <code>InvalidPolicyRevisionIdException</code> error.
     * </p>
     * 
     * @return Specifies a specific policy revision to delete. Provide a <code>PolicyRevisionId</code> to ensure an
     *         atomic delete operation. If the revision ID that you provide doesn't match the latest policy revision ID,
     *         the request will be rejected with an <code>InvalidPolicyRevisionIdException</code> error.
     */
    public final String policyRevisionId() {
        return policyRevisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(policyRevisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourcePolicyRequest)) {
            return false;
        }
        DeleteResourcePolicyRequest other = (DeleteResourcePolicyRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(policyRevisionId(), other.policyRevisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteResourcePolicyRequest").add("Name", name()).add("PolicyRevisionId", policyRevisionId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PolicyRevisionId":
            return Optional.ofNullable(clazz.cast(policyRevisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("policyRevisionId", POLICY_REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourcePolicyRequest, T> g) {
        return obj -> g.apply((DeleteResourcePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RumRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteResourcePolicyRequest> {
        /**
         * <p>
         * The app monitor that you want to remove the resource policy from.
         * </p>
         * 
         * @param name
         *        The app monitor that you want to remove the resource policy from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies a specific policy revision to delete. Provide a <code>PolicyRevisionId</code> to ensure an atomic
         * delete operation. If the revision ID that you provide doesn't match the latest policy revision ID, the
         * request will be rejected with an <code>InvalidPolicyRevisionIdException</code> error.
         * </p>
         * 
         * @param policyRevisionId
         *        Specifies a specific policy revision to delete. Provide a <code>PolicyRevisionId</code> to ensure an
         *        atomic delete operation. If the revision ID that you provide doesn't match the latest policy revision
         *        ID, the request will be rejected with an <code>InvalidPolicyRevisionIdException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRevisionId(String policyRevisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RumRequest.BuilderImpl implements Builder {
        private String name;

        private String policyRevisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourcePolicyRequest model) {
            super(model);
            name(model.name);
            policyRevisionId(model.policyRevisionId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPolicyRevisionId() {
            return policyRevisionId;
        }

        public final void setPolicyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
        }

        @Override
        public final Builder policyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteResourcePolicyRequest build() {
            return new DeleteResourcePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
