/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rum.model.MetricDestinationSummary;
import software.amazon.awssdk.services.rum.model.MetricDestinationSummaryListCopier;
import software.amazon.awssdk.services.rum.model.RumResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRumMetricsDestinationsResponse
extends RumResponse
implements ToCopyableBuilder<Builder, ListRumMetricsDestinationsResponse> {
    private static final SdkField<List<MetricDestinationSummary>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(ListRumMetricsDestinationsResponse.getter(ListRumMetricsDestinationsResponse::destinations)).setter(ListRumMetricsDestinationsResponse.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDestinationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRumMetricsDestinationsResponse.getter(ListRumMetricsDestinationsResponse::nextToken)).setter(ListRumMetricsDestinationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRumMetricsDestinationsResponse.memberNameToFieldInitializer();
    private final List<MetricDestinationSummary> destinations;
    private final String nextToken;

    private ListRumMetricsDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<MetricDestinationSummary> destinations() {
        return this.destinations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRumMetricsDestinationsResponse)) {
            return false;
        }
        ListRumMetricsDestinationsResponse other = (ListRumMetricsDestinationsResponse)((Object)obj);
        return this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRumMetricsDestinationsResponse").add("Destinations", this.hasDestinations() ? this.destinations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Destinations", DESTINATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRumMetricsDestinationsResponse, T> g) {
        return obj -> g.apply((ListRumMetricsDestinationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumResponse.BuilderImpl
    implements Builder {
        private List<MetricDestinationSummary> destinations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRumMetricsDestinationsResponse model) {
            super(model);
            this.destinations(model.destinations);
            this.nextToken(model.nextToken);
        }

        public final List<MetricDestinationSummary.Builder> getDestinations() {
            List<MetricDestinationSummary.Builder> result = MetricDestinationSummaryListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<MetricDestinationSummary.BuilderImpl> destinations) {
            this.destinations = MetricDestinationSummaryListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<MetricDestinationSummary> destinations) {
            this.destinations = MetricDestinationSummaryListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(MetricDestinationSummary ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<MetricDestinationSummary.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (MetricDestinationSummary)((MetricDestinationSummary.Builder)MetricDestinationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRumMetricsDestinationsResponse build() {
            return new ListRumMetricsDestinationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RumResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRumMetricsDestinationsResponse> {
        public Builder destinations(Collection<MetricDestinationSummary> var1);

        public Builder destinations(MetricDestinationSummary ... var1);

        public Builder destinations(Consumer<MetricDestinationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

