/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.rum.DefaultRumClientBuilder;
import software.amazon.awssdk.services.rum.RumClientBuilder;
import software.amazon.awssdk.services.rum.model.AccessDeniedException;
import software.amazon.awssdk.services.rum.model.ConflictException;
import software.amazon.awssdk.services.rum.model.CreateAppMonitorRequest;
import software.amazon.awssdk.services.rum.model.CreateAppMonitorResponse;
import software.amazon.awssdk.services.rum.model.DeleteAppMonitorRequest;
import software.amazon.awssdk.services.rum.model.DeleteAppMonitorResponse;
import software.amazon.awssdk.services.rum.model.GetAppMonitorDataRequest;
import software.amazon.awssdk.services.rum.model.GetAppMonitorDataResponse;
import software.amazon.awssdk.services.rum.model.GetAppMonitorRequest;
import software.amazon.awssdk.services.rum.model.GetAppMonitorResponse;
import software.amazon.awssdk.services.rum.model.InternalServerException;
import software.amazon.awssdk.services.rum.model.ListAppMonitorsRequest;
import software.amazon.awssdk.services.rum.model.ListAppMonitorsResponse;
import software.amazon.awssdk.services.rum.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rum.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rum.model.PutRumEventsRequest;
import software.amazon.awssdk.services.rum.model.PutRumEventsResponse;
import software.amazon.awssdk.services.rum.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rum.model.RumException;
import software.amazon.awssdk.services.rum.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.rum.model.TagResourceRequest;
import software.amazon.awssdk.services.rum.model.TagResourceResponse;
import software.amazon.awssdk.services.rum.model.ThrottlingException;
import software.amazon.awssdk.services.rum.model.UntagResourceRequest;
import software.amazon.awssdk.services.rum.model.UntagResourceResponse;
import software.amazon.awssdk.services.rum.model.UpdateAppMonitorRequest;
import software.amazon.awssdk.services.rum.model.UpdateAppMonitorResponse;
import software.amazon.awssdk.services.rum.model.ValidationException;
import software.amazon.awssdk.services.rum.paginators.GetAppMonitorDataIterable;
import software.amazon.awssdk.services.rum.paginators.ListAppMonitorsIterable;

@SdkPublicApi
@ThreadSafe
public interface RumClient
extends SdkClient {
    public static final String SERVICE_NAME = "rum";
    public static final String SERVICE_METADATA_ID = "rum";

    public static RumClient create() {
        return (RumClient)RumClient.builder().build();
    }

    public static RumClientBuilder builder() {
        return new DefaultRumClientBuilder();
    }

    default public CreateAppMonitorResponse createAppMonitor(CreateAppMonitorRequest createAppMonitorRequest) throws ConflictException, ServiceQuotaExceededException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public CreateAppMonitorResponse createAppMonitor(Consumer<CreateAppMonitorRequest.Builder> createAppMonitorRequest) throws ConflictException, ServiceQuotaExceededException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        return this.createAppMonitor((CreateAppMonitorRequest)((Object)((CreateAppMonitorRequest.Builder)CreateAppMonitorRequest.builder().applyMutation(createAppMonitorRequest)).build()));
    }

    default public DeleteAppMonitorResponse deleteAppMonitor(DeleteAppMonitorRequest deleteAppMonitorRequest) throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public DeleteAppMonitorResponse deleteAppMonitor(Consumer<DeleteAppMonitorRequest.Builder> deleteAppMonitorRequest) throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        return this.deleteAppMonitor((DeleteAppMonitorRequest)((Object)((DeleteAppMonitorRequest.Builder)DeleteAppMonitorRequest.builder().applyMutation(deleteAppMonitorRequest)).build()));
    }

    default public GetAppMonitorResponse getAppMonitor(GetAppMonitorRequest getAppMonitorRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public GetAppMonitorResponse getAppMonitor(Consumer<GetAppMonitorRequest.Builder> getAppMonitorRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        return this.getAppMonitor((GetAppMonitorRequest)((Object)((GetAppMonitorRequest.Builder)GetAppMonitorRequest.builder().applyMutation(getAppMonitorRequest)).build()));
    }

    default public GetAppMonitorDataResponse getAppMonitorData(GetAppMonitorDataRequest getAppMonitorDataRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public GetAppMonitorDataResponse getAppMonitorData(Consumer<GetAppMonitorDataRequest.Builder> getAppMonitorDataRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        return this.getAppMonitorData((GetAppMonitorDataRequest)((Object)((GetAppMonitorDataRequest.Builder)GetAppMonitorDataRequest.builder().applyMutation(getAppMonitorDataRequest)).build()));
    }

    default public GetAppMonitorDataIterable getAppMonitorDataPaginator(GetAppMonitorDataRequest getAppMonitorDataRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public GetAppMonitorDataIterable getAppMonitorDataPaginator(Consumer<GetAppMonitorDataRequest.Builder> getAppMonitorDataRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        return this.getAppMonitorDataPaginator((GetAppMonitorDataRequest)((Object)((GetAppMonitorDataRequest.Builder)GetAppMonitorDataRequest.builder().applyMutation(getAppMonitorDataRequest)).build()));
    }

    default public ListAppMonitorsResponse listAppMonitors(ListAppMonitorsRequest listAppMonitorsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public ListAppMonitorsResponse listAppMonitors(Consumer<ListAppMonitorsRequest.Builder> listAppMonitorsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        return this.listAppMonitors((ListAppMonitorsRequest)((Object)((ListAppMonitorsRequest.Builder)ListAppMonitorsRequest.builder().applyMutation(listAppMonitorsRequest)).build()));
    }

    default public ListAppMonitorsIterable listAppMonitorsPaginator(ListAppMonitorsRequest listAppMonitorsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public ListAppMonitorsIterable listAppMonitorsPaginator(Consumer<ListAppMonitorsRequest.Builder> listAppMonitorsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        return this.listAppMonitorsPaginator((ListAppMonitorsRequest)((Object)((ListAppMonitorsRequest.Builder)ListAppMonitorsRequest.builder().applyMutation(listAppMonitorsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, RumException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public PutRumEventsResponse putRumEvents(PutRumEventsRequest putRumEventsRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public PutRumEventsResponse putRumEvents(Consumer<PutRumEventsRequest.Builder> putRumEventsRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        return this.putRumEvents((PutRumEventsRequest)((Object)((PutRumEventsRequest.Builder)PutRumEventsRequest.builder().applyMutation(putRumEventsRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, RumException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, RumException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateAppMonitorResponse updateAppMonitor(UpdateAppMonitorRequest updateAppMonitorRequest) throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        throw new UnsupportedOperationException();
    }

    default public UpdateAppMonitorResponse updateAppMonitor(Consumer<UpdateAppMonitorRequest.Builder> updateAppMonitorRequest) throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, RumException {
        return this.updateAppMonitor((UpdateAppMonitorRequest)((Object)((UpdateAppMonitorRequest.Builder)UpdateAppMonitorRequest.builder().applyMutation(updateAppMonitorRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"rum");
    }
}

