/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.rules.testing;

import java.net.URI;
import java.util.Map;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.core.rules.testing.EndpointProviderTestCase;
import software.amazon.awssdk.core.rules.testing.model.Expect;
import software.amazon.awssdk.endpoints.Endpoint;

public class BaseEndpointProviderTest {
    protected final void verify(EndpointProviderTestCase tc) {
        Expect expect = tc.getExpect();
        Supplier<Endpoint> testMethod = tc.getTestMethod();
        if (expect.error() != null) {
            Assertions.assertThatThrownBy(testMethod::get).hasMessageContaining(expect.error());
        } else {
            Endpoint actualEndpoint = testMethod.get();
            Endpoint expectedEndpoint = expect.endpoint();
            Assertions.assertThat((URI)actualEndpoint.url()).isEqualTo((Object)expectedEndpoint.url());
            Assertions.assertThat((Map)actualEndpoint.headers()).isEqualTo((Object)expectedEndpoint.headers());
            AwsEndpointAttribute.values().forEach(attr -> {
                if (expectedEndpoint.attribute(attr) != null) {
                    Assertions.assertThat((Object)actualEndpoint.attribute(attr)).isEqualTo(expectedEndpoint.attribute(attr));
                } else {
                    Assertions.assertThat((Object)actualEndpoint.attribute(attr)).isNull();
                }
            });
        }
    }
}

