/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.rules.testing;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.rules.testing.AsyncTestCase;
import software.amazon.awssdk.core.rules.testing.SyncTestCase;
import software.amazon.awssdk.core.rules.testing.model.Expect;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public abstract class BaseRuleSetClientTest {
    protected static final AwsCredentialsProvider CREDENTIALS_PROVIDER = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"akid", (String)"skid"));
    private static SdkHttpClient syncHttpClient;
    private static SdkAsyncHttpClient asyncHttpClient;

    @BeforeAll
    public static void setup() {
        syncHttpClient = (SdkHttpClient)Mockito.mock(SdkHttpClient.class);
        asyncHttpClient = (SdkAsyncHttpClient)Mockito.mock(SdkAsyncHttpClient.class);
    }

    @BeforeEach
    public void methodSetup() {
        Mockito.reset((Object[])new SdkAutoCloseable[]{syncHttpClient, asyncHttpClient});
        Mockito.when((Object)syncHttpClient.prepareRequest((HttpExecuteRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("Oops")});
        Mockito.when((Object)asyncHttpClient.execute((AsyncExecuteRequest)ArgumentMatchers.any())).thenAnswer(i -> {
            AsyncExecuteRequest req = (AsyncExecuteRequest)i.getArgument(0, AsyncExecuteRequest.class);
            SdkAsyncHttpResponseHandler responseHandler = req.responseHandler();
            responseHandler.onError((Throwable)new RuntimeException("Oops"));
            return CompletableFutureUtils.failedFuture((Throwable)new RuntimeException("Something went wrong"));
        });
    }

    protected static void runAndVerify(SyncTestCase testCase) {
        String skipReason = testCase.skipReason();
        Assumptions.assumeTrue((skipReason == null ? 1 : 0) != 0, (String)skipReason);
        Expect expectation = testCase.expectation();
        Runnable r = testCase.operationRunnable();
        if (expectation.error() != null) {
            Assertions.assertThatThrownBy(r::run).hasMessageContaining(expectation.error());
        } else {
            Assertions.assertThatThrownBy(r::run).hasMessageContaining("Oops");
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpExecuteRequest.class);
            ((SdkHttpClient)Mockito.verify((Object)syncHttpClient)).prepareRequest((HttpExecuteRequest)requestCaptor.capture());
            URI requestUri = ((HttpExecuteRequest)requestCaptor.getValue()).httpRequest().getUri();
            Endpoint expectedEndpoint = expectation.endpoint();
            Assertions.assertThat((String)requestUri.getScheme()).isEqualTo(expectedEndpoint.url().getScheme());
            Assertions.assertThat((String)requestUri.getHost()).isEqualTo(expectedEndpoint.url().getHost());
            Assertions.assertThat((String)requestUri.getRawPath()).startsWith((CharSequence)expectedEndpoint.url().getRawPath());
        }
    }

    protected static void runAndVerify(AsyncTestCase testCase) {
        String skipReason = testCase.skipReason();
        Assumptions.assumeTrue((skipReason == null ? 1 : 0) != 0, (String)skipReason);
        Expect expectation = testCase.expectation();
        Supplier<CompletableFuture<?>> r = testCase.operationRunnable();
        CompletableFuture<?> executeFuture = r.get();
        if (expectation.error() != null) {
            Assertions.assertThatThrownBy(executeFuture::get).hasMessageContaining(expectation.error());
        } else {
            Assertions.assertThatThrownBy(executeFuture::get).hasMessageContaining("Oops");
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(AsyncExecuteRequest.class);
            ((SdkAsyncHttpClient)Mockito.verify((Object)asyncHttpClient)).execute((AsyncExecuteRequest)requestCaptor.capture());
            URI requestUri = ((AsyncExecuteRequest)requestCaptor.getValue()).request().getUri();
            Endpoint expectedEndpoint = expectation.endpoint();
            Assertions.assertThat((String)requestUri.getScheme()).isEqualTo(expectedEndpoint.url().getScheme());
            Assertions.assertThat((String)requestUri.getHost()).isEqualTo(expectedEndpoint.url().getHost());
        }
    }

    protected static SdkHttpClient getSyncHttpClient() {
        return syncHttpClient;
    }

    protected static SdkAsyncHttpClient getAsyncHttpClient() {
        return asyncHttpClient;
    }
}

